export default {
  data() {
    return {
      ageIndexCache: "",
      isAgeIndexChange: false
    };
  },
  computed: {
    // 场景不同暂不做整合
    // age() {
    //   const userAge = parseInt(moment(this.formData.birth).fromNow(), 10);
    //   return isNaN(userAge) ? 18 : userAge;
    // },
    // 年龄范围：['18~35', '31~35', '36~40', '41~45', '46~50', '51~55', '56~60']
    calFormData() {
      if (this.formData.productItem) {
        return this.formData.productItem;
      }
      if (this.formData) {
        return this.formData;
      }
    },
    ageIndex() {
      const { age } = this;
      let _index = 0;
      const ageRangeList = [
        [18, 30],
        [31, 35],
        [36, 40],
        [41, 45],
        [46, 50],
        [51, 55],
        [56, 60]
      ];
      _index = ageRangeList.findIndex(item => item[0] <= age && age <= item[1]);
      if (this.ageIndexCache !== _index) {
        this.ageIndexCache = _index;
        this.isAgeIndexChange = true;
      } else {
        this.isAgeIndexChange = false;
      }
      return _index === -1 ? 0 : _index;
    },
    amountOptions() {
      const { ageIndex, countOptions } = this;
      return countOptions.map((item, index) => {
        if (ageIndex === 6 && index > 3) {
          item.disabled = true;
        } else if (ageIndex > 2 && index > 5) {
          item.disabled = true;
        } else {
          item.disabled = false;
        }
        this.resetFormItemVal("amountInsured", item.disabled ? item.value : "");
        return item;
      });
    },
    insureTermOptions() {
      const { ageIndex: a, termOptions } = this;
      const { payPeriod: p } = this.calFormData;
      return termOptions.map((item, index) => {
        switch (index) {
          case 0:
            item.disabled = p === "3" || p === "4";
            break;
          case 1:
            item.disabled = p === "4" || a > 4;
            break;
          case 2:
            item.disabled = a > 2;
            break;
          case 3:
            item.disabled = (a > 0 && p === "4") || (a > 2 && p === "3") || a > 4;
            break;
          case 4:
            item.disabled = (a > 1 && p === "4") || (a > 3 && p === "3") || a > 5;
            break;
          case 5:
            item.disabled = (a > 2 && p === "4") || (a > 4 && p === "3");
            break;
          default:
            break;
        }
        this.resetFormItemVal("policyPeriod", item.disabled ? item.value : "");
        return item;
      });
    },
    insureBenefitOptions() {
      const { ageIndex: a, benefitOptions } = this;
      const { policyPeriod: p } = this.calFormData;
      return benefitOptions.map((item, index) => {
        switch (index) {
          case 0:
          case 1:
            break;
          case 2:
            if (a === 4 && +p === 6) {
              item.disabled = false;
            } else {
              item.disabled =
                p === "1" || (+p >= 4 && +p <= 6 && a > 3) || (a === 3 && (+p === 1 || +p === 4));
            }
            break;
          case 3:
            if (a === 2 && (+p === 6 || +p === 3)) {
              item.disabled = false;
            } else if (a === 2 && +p !== 3) {
              item.disabled = true;
            } else {
              item.disabled =
                +p < 3 || (a > 1 && +p !== 6) || (a === 1 && +p === 4) || (a >= 3 && +p === 6);
            }
            break;
          default:
            break;
        }
        this.resetFormItemVal("payPeriod", item.disabled ? item.value : "");
        return item;
      });
    }
  }
  // 场景不同暂不做整合
  // methods: {
  //   resetFormItemVal(key, val) {
  //     if (this.formData.birth && this.formData[key] && !val) {
  //       switch (key) {
  //         case "amountInsured":
  //           this.$notify({ type: "warning", message: "已超出该年龄承保的最高保额，请重新选择" });
  //           break;
  //         case "policyPeriod":
  //         case "payPeriod":
  //           this.$notify({ type: "warning", message: "交费期间不应长于保障期间，请重新选择" });
  //           break;
  //         default:
  //           break;
  //       }
  //     }
  //     if (this.formData[key] === val) {
  //       this.formData[key] = "";
  //     }
  //   }
  // }
};
