/*
 * @Description: autoSaveForm mixins
 * @LastEditors: gzw
 * @Date: 2019-08-14 15:53:37
 * @LastEditTime: 2020-08-20 13:49:26
 */

import localStorage from "@/service/localStorage";
export default {
  data() {
    return {
      autoSaveTimer: null
    };
  },
  methods: {
    autoSaveHandler(key, saveKey, interval = 1000) {
      if (this.autoSaveTimer) {
        clearTimeout(this.autoSaveTimer);
      }
      const val = this[key];
      this.autoSaveTimer = setTimeout(() => {
        localStorage.set(saveKey, val);
      }, interval);
    },
    clearSaveHandler(key) {
      localStorage.remove(key);
    },
    hasAutoSaveData(key) {
      return !!localStorage.get(key);
    },
    getSaveParams(key) {
      return localStorage.get(key);
    },
    getSaveInfoHandler(key, target) {
      this[target] = localStorage.get(key);
      this.$forceUpdate();
    }
  }
};
