import req from "@/service/http";

// 查询订单列表
export const getPolicyList = () => {
  return req.get("policy_order/list");
};

// 查询订单详情
export const getPolicyDetail = orderNo => {
  return req.get(`/policy_order/detail?orderNo=${orderNo}`);
};

// 查询订单详情(购买成功页面使用)
export const getGenPolicyDetail = orderNo => {
  return req.get(`/policy_order/general?orderNo=${orderNo}`);
};

// 查询缴费记录
export const getPayRecord = policySecId => {
  return req.get(`/policy/pay_record?policySecId=${encodeURIComponent(policySecId)}`);
};

// 保单自动续保状态管理
export const updateRenewal = (policySecId, status) => {
  return req.post("/policy/auto_renew_policy", { policySecId, status });
};

// 华贵- 回访插件URL
export const returnOnline = params => {
  return req.post("/third/huagui/returnOnline", params);
};

// 电子保单下载获取下载地址
export const getElectronicInsurance = params => {
  return req.post("/policy/download/img-state", params);
};
