import Vue from "vue";
import Vuex from "vuex";

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    activeIdx: 0,
    isLoading: true
  },
  mutations: {
    setActiveIdx(state, value) {
      state.activeIdx = value;
    },
    setIsLoading(state, value) {
      state.isLoading = value;
    }
  },
  actions: {
    setActiveIdx({commit}, args) {
      commit('setActiveIdx', args)
    },
    setIsLoading({commit}, args) {
      commit('setIsLoading', args)
    }
  },
  modules: {}
});
