import male from "@/assets/images/user/male@2x.png";
import female from "@/assets/images/user/female@2x.png";

const questionList = [
  {
    id: 1,
    question: "请问您的性别是?",
    component: "Gender",
    type: "gender",
    selectType: "radio",
    answer: ""
  },
  {
    id: 2,
    question: "请问您的年龄是?",
    component: "Age",
    type: "age",
    selectType: "radio",
    answer: ""
  },
  {
    id: 3,
    question: "请问您结婚了吗?",
    component: "Select",
    type: "marrige",
    selectType: "radio",
    answer: ""
  },
  {
    id: 4,
    question: "嘘…悄悄告诉我您月收入是多少?",
    component: "Select",
    type: "income",
    selectType: "radio",
    answer: ""
  },
  {
    id: 5,
    question: "生活中，您有下面的习惯、环境吗",
    component: "Select",
    type: "environment",
    selectType: "multi-select",
    answer: ""
  },
  {
    id: 6,
    question: "您平时的出行方式是什么呢？",
    component: "Select",
    selectType: "multi-select",
    type: "travel",
    answer: ""
  },
  {
    id: 7,
    question: "您目前是否还有其他保险呢？",
    component: "Select",
    type: "insurance",
    selectType: "multi-select",
    answer: ""
  }
];

const ageScope = new Array(48)
  .fill(0)
  .map((v, index) => 1955 + index + "年")
  .sort((a, b) => (a === b ? 0 : a < b ? 1 : -1));

const genderList = [
  {
    image: male,
    value: "male",
    answer: "男神"
  },
  {
    image: female,
    value: "female",
    answer: "女神"
  }
];

const selectList = {
  marrige: {
    data: ["单身贵族爱自由", "幸福的二人世界", "家有儿女初长成"],
    type: "radio",
    selected: [],
    required: true
  },
  income: {
    data: [
      ["3000元以下", "3000~5000元"],
      ["5000~8000元", "8000~12000元"],
      ["12000~18000元", "18000元以上"]
    ],
    type: "radio",
    selected: [],
    required: true
  },
  environment: {
    data: [
      ["喝酒", "抽烟/二手烟"],
      ["熬夜", "不按时吃饭"],
      ["工作压力大", "不常运动"]
    ],
    type: "multi-select",
    selected: [],
    required: false
  },
  travel: {
    data: [
      ["开车", "公共交通"],
      ["非机动车", "步行"],
      ["坐火车", "坐飞机"]
    ],
    type: "multi-select",
    selected: [],
    required: false
  },
  insurance: {
    data: [["社保", "医疗险"], ["重疾险", "意外险"], ["寿险"]],
    type: "multi-select",
    selected: [],
    required: false
  }
};

const answerMap = {
  gender: {
    男神: 1,
    女神: 0
  },
  marrige: {
    单身贵族爱自由: 1,
    幸福的二人世界: 2,
    家有儿女初长成: 3
  },
  income: {
    "3000元以下": 1,
    "3000~5000元": 2,
    "5000~8000元": 3,
    "8000~12000元": 4,
    "12000~18000元": 5,
    "18000元以上": 6
  }
};

const paramsMap = {
  gender: "gender",
  age: "age",
  marrige: "married",
  income: "monthlyIncome",
  environment: "hobbit",
  travel: "travelWay",
  insurance: "otherPolicy"
};

export { questionList, ageScope, genderList, selectList, answerMap, paramsMap };
