/*
 * @Description: weixin-js-sdk mixins
 * @LastEditors: gzw
 * @Date: 20120-08-30 18:40:11
 * @LastEditTime: 2020-08-30 19:28:02
 */
import cfg from "@/config/index";
import { getwxAuth } from "@/api/user";
import wx from "weixin-js-sdk";
export default {
  data() {
    return {
      wxAuthInfo: {}
    };
  },
  methods: {
    async getWxShareInfo(
      title = "wwww",
      desc = "aaaa",
      link = window.location.href,
      imgUrl = "https://mangguo-mg.liangkebang.net/sharetest.png"
    ) {
      const res = await getwxAuth({
        appId: cfg.wxAppId,
        url: window.location.href
      });
      const { appId, timestamp, nonceStr, signature } = res;
      wx.config({
        debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
        appId, // 必填，公众号的唯一标识，填自己的！
        timestamp, // 必填，生成签名的时间戳，刚才接口拿到的数据
        nonceStr, // 必填，生成签名的随机串
        signature, // 必填，签名，见附录1
        jsApiList: ["onMenuShareTimeline", "onMenuShareAppMessage"]
      });
      wx.ready(function() {
        //分享到朋友圈
        wx.onMenuShareTimeline({
          title, // 分享时的标题
          link, // 分享时的链接
          imgUrl, // 分享时的图标
          success: function() {
            console.log("分享成功");
          },
          cancel: function() {
            console.log("取消分享");
          }
        });
        //分享给朋友
        wx.onMenuShareAppMessage({
          title,
          desc,
          link,
          imgUrl,
          type: "link",
          dataUrl: "",
          success: function() {
            console.log("分享成功");
          },
          cancel: function() {
            console.log("取消分享");
          }
        });
      });
    }
  }
};
