import good01 from "@/assets/images/goods/goods-01.png";
import good02 from "@/assets/images/goods/goods-02.png";
import good03 from "@/assets/images/goods/goods-03.png";
import good04 from "@/assets/images/goods/goods-04.png";
import good05 from "@/assets/images/goods/goods-05.png";
import medical_closed from "@/assets/images/user/medical_closed@2x.png";
import casualty_closed from "@/assets/images/user/casualty_closed@2x.png";
import illness_closed from "@/assets/images/user/illness_closed@2x.png";
import life_closed from "@/assets/images/user/life_closed@2x.png";
import medical from "@/assets/images/user/medical@2x.png";
import casualty from "@/assets/images/user/casualty@2x.png";
import illness from "@/assets/images/user/illness@2x.png";
import life from "@/assets/images/user/life@2x.png";

export default [
  {
    id: "TKYLX001",
    itype: "mi", // 保险类型，英文收字母缩写，详情需要传
    scope: [1, 2, 3], // 范围，列表中区分类型用，1成人 2老年 3少儿
    img: good01,
    title: "万家保·百万医疗险",
    sub: "看病报销医药费，最高600万",
    glory: "好评榜第1名",
    price: "1",
    unit: "首月",
    allow: true,
    shadowColor: "rgba(255, 234, 183, 0.8)",
    termType: "short",
    icon_closed: medical_closed,
    icon: medical,
    guarantee_title: "医疗保障",
    guarantee_sub: "看病报销医药费,最高600万",
    company: "泰康在线",
    company_name: "泰康在线财产保险股份有限公司",
    payType: [
      { label: "月缴", value: 1 },
      { label: "一次交清", value: 2 }
    ],
    policyPeriod: [],
    paymentInstruction:
      "因责任内“医疗和住院”所产生的费用，医疗险100%报销，赔多少钱，取决于您实际花费多少"
  },
  {
    id: "HTDQZJX001",
    itype: "cii",
    scope: [1, 2, 3],
    img: good02,
    title: "万家保·重疾轻症险",
    sub: "100种重疾+40种轻症确诊即赔",
    glory: "",
    price: "3",
    unit: "首月",
    allow: true,
    shadowColor: "rgba(255, 216, 191, 0.8)",
    termType: "short",
    icon_closed: illness_closed,
    icon: illness,
    guarantee_title: "重疾保障",
    guarantee_sub: "100种重疾+40种轻症确诊即赔",
    company: "华泰财险",
    company_name: "华泰财产保险有限公司",
    payType: [
      { label: "月缴", value: 1 },
      { label: "一次交清", value: 2 }
    ],
    policyPeriod: [],
    paymentInstruction:
      "“确诊”责任内的重大疾病，重疾险即100%赔付，赔多少钱，取决于您投保的保额是多少"
  },
  {
    id: "ZAYWX001",
    itype: "ai",
    scope: [1, 2, 3],
    img: good03,
    title: "万家保·综合意外险",
    sub: "意外风险覆盖全，保额最高100万",
    glory: "开车必备",
    price: "145",
    unit: "年起",
    allow: true,
    shadowColor: "rgba(133, 138, 255, 0.5)",
    termType: "short",
    icon_closed: casualty_closed,
    icon: casualty,
    guarantee_title: "意外保障",
    guarantee_sub: "意外风险覆盖全,保额最高100万",
    company: "众安保险",
    company_name: "众安在线财产保险股份有限公司",
    payType: [],
    policyPeriod: [],
    paymentInstruction:
      "因意外导致的身故，意外险100%赔付，伤残，按比例赔付，赔多少钱，取决于您投保的保额是多少"
  },
  {
    id: "BNZJX001",
    itype: "cii",
    scope: [1, 3],
    img: good05,
    url: "",
    title: "百年康惠保(2.0)重大疾病险",
    sub: "终身保障155种重疾，最多赔付6次",
    glory: "",
    price: "256",
    unit: "年起",
    allow: true,
    shadowColor: "rgba(255, 216, 191, 0.8)",
    termType: "long",
    icon_closed: illness_closed,
    icon: illness,
    guarantee_title: "重疾保障",
    guarantee_sub: "终身保障155种重疾，最多赔付6次",
    company: "百年人寿",
    company_name: "",
    payType: [{ label: "年缴", value: 1 }],
    policyPeriod: [
      { label: "保至70周岁", value: 1 },
      { label: "保至终身", value: 2 }
    ],
    paymentInstruction:
      "“确诊”责任内的重大疾病，重疾险即100%赔付，赔多少钱，取决于您投保的保额是多少"
  },
  {
    id: "HGSX001",
    itype: "li",
    scope: [1, 2],
    img: good04,
    title: "华贵大麦2020定期寿险",
    sub: "最高350万保额，顶梁柱必备",
    glory: "顶梁柱必备",
    price: "15.5",
    shadowColor: "rgba(221, 185, 132, 0.39)",
    unit: "年起",
    allow: true,
    termType: "long",
    icon_closed: life_closed,
    icon: life,
    guarantee_title: "人寿保障",
    guarantee_sub: "最高350万保额,顶梁柱必备",
    company: "华贵人寿",
    company_name: "华贵人寿保险股份有限公司",
    payType: [{ label: "年缴", value: 1 }],
    policyPeriod: [
      { label: "10年", value: 1 },
      { label: "20年", value: 2 },
      { label: "30年", value: 3 },
      { label: "保至60周岁", value: 4 },
      { label: "保至65周岁", value: 5 },
      { label: "保至70周岁", value: 6 }
    ],
    paymentInstruction:
      "“家庭顶梁柱”的身故，寿险100%赔付收入损失 ，赔多少钱，取决于您投保的保额是多少"
  }
];
