import req from "@/service/http";

// 查询订单列表
export const getPolicyList = () => {
  return req.get("policy_order/list");
};

// 查询订单详情
export const getPolicyDetail = orderNo => {
  return req.get(`/policy_order/detail?orderNo=${orderNo}`);
};

// 查询订单详情(购买成功页面使用)
export const getGenPolicyDetail = orderNo => {
  return req.get(`/policy_order/general?orderNo=${orderNo}`);
};

// 查询缴费记录
export const getPayRecord = policySecId => {
  return req.get(`/policy/pay_record?policySecId=${policySecId}`);
};

// 保单自动续保状态管理
export const updateRenewal = (policySecId, status) => {
  return req.post(`/auto_renew_policy/${policySecId}/${status}`);
};
