import Vuex from '@wepy/x';

export default new Vuex.Store({
  state: {
    userInfo: {
      avatarUrl: '/static/images/user@2x.png'
    },
    isConnected: true,
    safeAreaStyle: ''
  },
  mutations: {
    setInfo (state, info) {
      state.userInfo = info;
    },
    setIsConnected (state, isConnected) {
      state.isConnected = isConnected;
    },
    setSafeAreaStyle (state, safeAreaStyle) {
      state.safeAreaStyle = safeAreaStyle;
    }
  },
  actions: {
    setUserInfo ({ commit }, info) {
      commit('setInfo', info);
    },
    setIsConnected ({ commit }) {
      const isConnected = wx.getStorageSync('onNetworkStatusChange');
      commit('setIsConnected', isConnected);
    },
    setSafeAreaStyle ({ commit }, safeAreaStyle) {
      commit('setSafeAreaStyle', safeAreaStyle);
    }
  }
});
