import wepy from '@wepy/core';

const baseUrl = 'localhost:8000';

const request = (url, options) => {
  const defaultOptions = {
    method: 'post',
    header: { 'content-type': 'applicction/x-www-form-urlencoded' }
  };
  options = { ...defaultOptions, ...options };
  url = baseUrl + url;

  const isConnected = wx.getStorageSync('onNetworkStatusChange');
  if (!isConnected) {
    wx.showToast({
      title: '无网络',
      icon: 'loading',
      duration: 2000
    });
    return;
  }

  const promise = new Promise((resolve, reject) => {
    wepy.request({
      url: url,
      data: options.data,
      method: options.method,
      header: options.header,
      success: res => {
        if (res.statusCode == 200) {
          if (res.data.code == '2000') {
            resolve(res.data.data);
          }
        }
        reject(res);
      },
      fail: res => {
        reject(res);
      }
    });
  });
  return promise;
};

const post = (url, data, header) => {
  const options = {
    method: 'post',
    data,
    header
  };
  if (!header) delete options.header;
  return request(url, options);
};

const get = (url, data) => {
  const options = {
    method: 'get',
    data
  };
  return request(url, options);
};

module.exports = {
  post: post,
  get: get,
  request
};
