import wepy from 'wepy';

const wxRequest = async (params = {}, url) => {
  console.log('wxRequest', params);
  const isConnected = wx.getStorageSync('onNetworkStatusChange');
  if (!isConnected) {
    wx.showToast({
      title: '无网络',
      icon: 'loading',
      duration: 2000
    });
    return;
  }
  // tip.loading()
  let data = params.query || {};
  const header = params.header || {};
  let res = await wepy.request({
    url: url,
    method: params.method || 'GET',
    data: data,
    header: header
  });
  // tip.loaded()
  console.log('wxRequest', res);
  return res;
};

module.exports = {
  wxRequest
};
