import Vuex from '@wepy/x';

export default new Vuex.Store({
  state: {
    userInfo: '',
    isConnected: true
  },
  mutations: {
    setInfo (state, info) {
      state.userInfo = info;
    },
    setIsConnected (state, isConnected) {
      state.isConnected = isConnected;
    }
  },
  actions: {
    setUserInfo ({ commit }, info) {
      commit('setInfo', info);
    },
    setIsConnected ({ commit }) {
      const isConnected = wx.getStorageSync('onNetworkStatusChange');
      commit('setIsConnected', isConnected);
    }
  }
});
