import http from './wxRequest';

module.exports = {
  login(code) {
    return http.post(`/api/user/login?code=1235`);
  },
  register(params) {
    return http.post('/api/user/register', params, { 'content-type': 'application/json' });
  },
  getUserInfo(params) {
    return http.post('/api/user/main', params);
  },
  getAwardsInfo(params) {
    return http.post('/api/prize/list', params);
  },
  getAwardsDetail(params) {
    return http.post('/api/prize/batch', params);
  },
  getActivityFeed(params) {
    return http.post('/api/activity/feed', params);
  },
  addGold(params) {
    return http.post('/api/user/book', params);
  },
  signIn(params) {
    return http.post('/api/user/signin', params, { 'content-type': 'application/json' });
  },
  getPrizeList(params) {
    return http.post('/api/prize/list', params, { 'content-type': 'application/json' });
  },
  getRaffles() {
    return http.post('/api/user/join/list');
  },
  getOneRaffle(params) {
    return http.post('/api/user/join/list',params);
  },
  getUserPhone() {
    return http.post('/api/user/get/phone');
  },
  confirmRaffle(params) {
    return http.post('/api/user/join/confirm',params);
  },
  updateUserPhone(params) {
    return http.post('/api/user/update/phone',params);
  },
  getPrize(params){
    return http.post('/api/user/price/receive',params);
  }
};
