import http from './wxRequest';
import qs from 'qs';

module.exports = {
  login(code) {
    return http.post(`/api/user/login?code=${code}`);
  },
  register(params) {
    return http.post('/api/user/register', params, { 'content-type': 'application/json' });
  },
  getUserInfo(params) {
    return http.post('/api/user/main', params);
  },
  getAwardsInfo(params) {
    return http.post('/api/prize/list', params);
  },
  getAwardsDetail(params) {
    return http.post('/api/prize/batch', qs.stringify(params));
  },
  getActivityFeed(params) {
    return http.post('/api/prize/feed', qs.stringify(params));
  },
  addGold(params) {
    return http.post('/api/user/book', qs.stringify(params));
  },
  signIn(params) {
    return http.post('/api/user/signin', params, { 'content-type': 'application/json' });
  },
  getPrizeList(params) {
    return http.post('/api/prize/list', params, { 'content-type': 'application/json' });
  },
  getRaffles() {
    return http.post('/api/user/join/list');
  },
  getOneRaffle(params) {
    return http.post('/api/user/join/info',params);
  },
  getUserPhone() {
    return http.post('/api/user/get/phone');
  },
  confirmRaffle(params) {
    return http.post('/api/user/join/confirm', params);
  },
  updateUserPhone(params) {
    return http.post('/api/user/update/phone', params);
  },
  getPrize(params){
    return http.post('/api/user/prize/receive', params, { 'content-type': 'application/json' });
  }
};
