import Vuex from '@wepy/x';

export default new Vuex.Store({
  state: {
    userInfo: {
      avatarUrl: 'data:image/png;base64,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'
    },
    isConnected: true,
    safeAreaStyle: ''
  },
  mutations: {
    setInfo (state, info) {
      state.userInfo = info;
    },
    setIsConnected (state, isConnected) {
      state.isConnected = isConnected;
    },
    setSafeAreaStyle (state, safeAreaStyle) {
      state.safeAreaStyle = safeAreaStyle;
    }
  },
  actions: {
    setUserInfo ({ commit }, info) {
      commit('setInfo', info);
    },
    setIsConnected ({ commit }) {
      const isConnected = wx.getStorageSync('onNetworkStatusChange');
      commit('setIsConnected', isConnected);
    },
    setSafeAreaStyle ({ commit }, safeAreaStyle) {
      commit('setSafeAreaStyle', safeAreaStyle);
    }
  }
});
