function getCommonDivisor(firstNum, secondNum) {
  if (secondNum === 0) return firstNum;

  var remainder = parseInt(firstNum % secondNum);

  return getCommonDivisor(secondNum, remainder);
}

function getProbability (quantity, coinQuantity) {
  // 如果用户克币数是0
  if (quantity === 0) {
    return '0';
  }
  var divisor = getCommonDivisor(quantity, coinQuantity);
  var value = quantity / divisor;
  var value2 = coinQuantity / divisor;
  // 如果分子比分母大说明中奖概率是100%，那么返回中奖概率
  if (value >= value2) {
    return '100%';
  } else {
    return value + '/' + value2;
  }
}

function checkUpdateVersion() {
  //创建 UpdateManager 实例
  const updateManager = wx.getUpdateManager();
  //检测版本更新
  updateManager.onCheckForUpdate(function(res) {
    console.log(res,'版本更新');
    // 请求完新版本信息的回调
    if (res.hasUpdate) {
      //监听小程序有版本更新事件
      updateManager.onUpdateReady(function() {
        wx.showModal({
          title: '更新提示',
          content: '新版本已经准备好，是否重启应用？',
          success(res) {
            if (res.confirm) {
              // 新的版本已经下载好，调用 applyUpdate 应用新版本并重启
              updateManager.applyUpdate();
            }
          }
        })
      })

      updateManager.onUpdateFailed(function() {
        // 新版本下载失败
        wx.showModal({
          title: '已经有新版本咯~',
          content: '请您删除当前小程序，到微信 “发现-小程序” 页，重新搜索打开呦~',
        })
      })
    }
  })
}
module.exports = {
  getProbability,
  checkUpdateVersion,
};
