import React from 'react';
import { Modal, Row, Col, Input, Form, Select, notification } from 'antd';
import { audit } from '../appeal/services';

const { TextArea } = Input;
const FormItem = Form.Item;
const { Option } = Select;

const AuditModal = props => {
  const {
    modalVisible,
    onCancel,
    data,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
  } = props;

  const handleOk = () => {
    // 掉接口
    // 成功后掉取消接口
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const auditData = await audit({
          ...fieldsValue,
          appealNo: data.appealNo,
        });
        if (auditData && auditData.code === '0000') {
          notification.success({ message: '审核成功' });
          resetFields();
          onCancel(true);
        }
      }
    });
  };
  const layout = {
    labelCol: { span: 3 },
    wrapperCol: { span: 15 },
  };
  const isAgree = () => getFieldValue('appealResult') === '1';
  const isRefuse = () => getFieldValue('appealResult') && getFieldValue('appealResult') !== '1';
  return (
    <Modal
      destroyOnClose
      title="订单审核"
      width="800px"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => handleOk()}
      bodyStyle={{ maxHeight: '800px', minHeight: '200px', overflow: 'auto' }}
    >
      {data ? (
        <div>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>申诉单ID: {data.appealNo}</p>
            </Col>
            <Col span={12}>
              <p>订单ID: {data.orderNo}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>售后单ID: {data.serviceNo}</p>
            </Col>
            <Col span={12}>
              <p>商家名称: {data.merchantName}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>商家手机号: {data.merchantPhone}</p>
            </Col>
            <Col span={12}>
              <p>商家退货地址: {data.merchantAddress}</p>
            </Col>
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row type="flex" gutter={[10, 20]}>
            <Col span={13}>
              <p>是否同意售后: {data.isAgree}</p>
            </Col>
          </Row>
          <Row type="flex" gutter={[10, 20]} style={{ marginBottom: '10px' }}>
            <Col span={4}>商家拒绝原因:</Col>
            <Col span={20}>
              <p style={{ width: '70%', marginLeft: '-25px' }}> {data.serviceReason}</p>
            </Col>
          </Row>

          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={12}>争议问题描述: {data.disputeDesc}</Col>
            {/* <Col span={16}>
              <TextArea value={data.disputeDesc} />
            </Col> */}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />

          <Row type="flex" align="middle" gutter={[10, 20]} style={{ minHeight: '100px' }}>
            <Col>售后凭证： </Col>
            {data.proofs &&
              data.proofs.split(',').map(item => (
                <Col key={item} span={4}>
                  <img key={item} width="100%" src={item} alt="" />
                </Col>
              ))}
          </Row>
          <Row
            type="flex"
            justify="start"
            align="middle"
            gutter={[10, 20]}
            style={{ minHeight: '100px' }}
          >
            <Col span={3}>补充资料：</Col>
            {data.supplement &&
              data.supplement.split(',').map(item => (
                <Col key={item} span={8}>
                  <img width="100%" src={item} key={item} alt="" />
                </Col>
              ))}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row gutter={[10, 20]}>
            <Form {...layout} name="formData">
              <FormItem label="审核结果">
                {getFieldDecorator('appealResult')(
                  <Select placeholder="选择审核结果">
                    <Option value="1">同意</Option>
                    <Option value="2">不同意</Option>
                  </Select>,
                )}
              </FormItem>
              {isAgree() && (
                <div>
                  <FormItem label="退货地址">
                    {getFieldDecorator('receiveAddress', {
                      rules: [
                        {
                          required: true,
                          message: '请填写正确退货地址!',
                          pattern: /^([\u4E00-\uFA29]|[\uE7C7-\uE7F3]|[a-zA-Z0-9_！@#￥%……&*（）——+【】《》、；‘，。!@#$%^&*()_+{}|:“”<>?’~·])+$/gi,
                        },
                      ],
                    })(<Input placeholder="最多输入50个字符" maxLength="50" allowClear />)}
                  </FormItem>
                  <FormItem label="收件人">
                    {getFieldDecorator('receiverName', {
                      rules: [
                        {
                          required: true,
                          message: '请填写正确收件人!',
                          pattern: /^[A-Za-z0-9\u4e00-\u9fa5]+$/,
                        },
                      ],
                    })(<Input placeholder="最多输入25个字符" maxLength="25" allowClear />)}
                  </FormItem>
                  <FormItem label="手机号码">
                    {getFieldDecorator('receiverPhone', {
                      rules: [
                        {
                          pattern: new RegExp(/^1[3456789]\d{9}$/, 'g'),
                          message: '手机号码格式不正确!',
                        },
                        {
                          required: true,
                          message: '请填写手机号码!',
                        },
                      ],
                    })(<Input placeholder="11位数字" maxLength="11" allowClear />)}
                  </FormItem>
                </div>
              )}
              {isRefuse() && (
                <FormItem label="拒绝原因">
                  {getFieldDecorator('refuseReason', {
                    rules: [
                      {
                        required: true,
                        message: '请填写拒绝原因!',
                      },
                    ],
                  })(
                    <TextArea
                      placeholder="请填写拒绝原因"
                      allowClear
                      autoSize={{ minRows: 3, maxRows: 6 }}
                    />,
                  )}
                </FormItem>
              )}
            </Form>
          </Row>
        </div>
      ) : (
        '暂无详情信息'
      )}
    </Modal>
  );
};

export default Form.create()(AuditModal);
