import { Button } from 'antd';
import React, { useState, useEffect, useRef } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { FormInstance } from 'antd/lib/form';
import LogisticsForm from './components/LogisticsForm';
import style from './styles.less';
import PopoverDom from './components/PreviewImage';
import LogisticsCom from './components/LogisticsCom';
import {
  queryToSend,
  queryExpress,
  getGoods,
  getLogistics,
  downOrder,
  getLogisticsInfo,
  getJDLogisticsInfo,
} from './service';

const TableList = props => {
  const [companys, setCompanys] = useState([]);
  const [LogisticsModalVisible, handleModalVisible] = useState(false);
  const [skuList, setSkuList] = useState([]);
  const [LogisticsData, setLogisticsData] = useState([{}]);
  const [ShowUpdateBtn] = useState([2, 5]);
  const [LogisticsComList, setLogisticsComList] = useState({});
  const [LogisticsComModalVisible, handleComModalVisible] = useState(false);

  const actionRef = useRef();
  const ref = useRef(FormInstance);
  const handleCom = async (record, skuItem) => {
    const tempObj = {
      expressCompanyCode: skuItem?.expressCompanyCode ?? '',
      expressCompanyName: skuItem.expressCompanyName ?? '',
      deliveryNo: skuItem?.deliveryNo ?? '',
      detailList: [],
      key: Date.now(),
    };
    const skuSource = record.skuSource?.value ?? null;
    const sourceItem = [2, 5]; // 2:京东企业购；5:京东开普勒；
    const isJD = sourceItem.includes(skuSource);
    const data = isJD
      ? await getJDLogisticsInfo(skuItem.orderSkuId)
      : await getLogisticsInfo(skuItem?.expressCompanyCode, skuItem?.deliveryNo);
    if (!data) {
      return;
    }
    tempObj.expressCompanyName = data?.logisticsName || tempObj.expressCompanyName;
    tempObj.deliveryNo = data?.logisticsBillNo || tempObj.deliveryNo;
    if (data.logisticsList?.length) {
      data.logisticsList.forEach(v => {
        tempObj.detailList = [...tempObj.detailList, ...v.detailList];
      });
    }
    handleComModalVisible(true);
    setLogisticsComList(tempObj);
  };

  const renderContent = (record, key) =>
    record.mchOrderSkuVoList.map((item, index) => (
      <p
        className={[
          'tableContent',
          index < record?.mchOrderSkuVoList?.length - 1 ? 'border' : null,
        ].join(' ')}
        key={item.orderSkuId}
      >
        {key === 'skuName' ? <PopoverDom name={item[key]} url={item.imageUrl} /> : ''}
        {key === 'action' && props.type === 2 ? (
          <Button
            size="small"
            type="primary"
            onClick={() => {
              handleCom(record, item);
            }}
          >
            查看物流
          </Button>
        ) : (
          item[key]
        )}
      </p>
    ));

  const columns = [
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      key: 'orderNo',
      order: 6,
      width: 250,
      fixed: 'left',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      order: 6,
      hideInTable: true,
    },
    {
      title: '交易时间',
      dataIndex: 'orderTime',
      key: 'orderTime',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      width: 400,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'skuName'),
    },
    {
      title: '商品规格',
      dataIndex: 'skuAttr',
      key: 'skuAttr',
      width: 200,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'skuAttr'),
    },
    {
      title: '商品数量',
      dataIndex: 'count',
      key: 'count',
      width: 100,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'count'),
    },
    {
      title: '商品自编码',
      dataIndex: 'thirdSpuNo',
      key: 'thirdSpuNo',
      width: 120,
      hideInSearch: true,
      className: 'colStyle',
      render: (_, record) => renderContent(record, 'thirdSpuNo'),
    },
    {
      title: '收货人手机',
      dataIndex: 'receiverPhone',
      key: 'receiverPhone',
      order: 4,
      width: 150,
    },
    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
      key: 'receiverName',
      order: 3,
      width: 120,
    },
    {
      title: '收货地址',
      dataIndex: 'fullAddress',
      key: 'fullAddress',
      hideInSearch: true,
      width: 350,
    },
    {
      title: '物流公司',
      dataIndex: 'expressCompanyName',
      key: 'expressCompanyName',
      width: 100,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'expressCompanyName'),
    },
    {
      title: '物流单号',
      dataIndex: 'deliveryNo',
      key: 'deliveryNo',
      width: 180,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'deliveryNo'),
    },
    {
      title: '物流信息',
      dataIndex: 'action',
      key: 'action',
      width: 150,
      hideInSearch: true,
      className: 'colStyle',
      render: (_, record) => renderContent(record, 'action'),
    },
    {
      title: '订单状态',
      dataIndex: 'orderStatus',
      key: 'orderStatus',
      width: 120,
      hideInSearch: true,
      valueEnum: {
        12: '待发货',
        13: '待收货',
        21: '订单完成',
      },
    },
    {
      title: '订单开始时间',
      dataIndex: 'beginTime',
      key: 'beginTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '订单结束时间',
      dataIndex: 'endTime',
      key: 'endTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 150,
      fixed: 'right',
      render: (_, record) => (
        <React.Fragment>
          {ShowUpdateBtn.includes(record?.skuSource?.value) ? null : (
            <Button
              type="primary"
              style={{
                marginBottom: '10px',
              }}
              onClick={async () => {
                const skuListData = await getGoods(record?.orderId);
                let logisticsData = [{}];
                setSkuList(skuListData);
                const data = await getLogistics(record?.orderId);
                logisticsData = data.map(item => ({
                  selectedGoods: item?.skus?.map(sku => sku?.orderSkuId),
                  selectedCompany: item.expressCompanyCode
                    ? `${item?.expressCompanyCode}-${item?.expressCompanyName}`
                    : null,
                  orderNum: item?.deliveryNo,
                }));
                setLogisticsData(logisticsData);
                handleModalVisible(true);
              }}
            >
              {props.type === 2 ? '更新物流信息' : '填写物流信息'}
            </Button>
          )}
        </React.Fragment>
      ),
    },
  ];
  const reload = () => {
    handleModalVisible(false);
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };

  useEffect(() => {
    const getCompanys = async () => {
      const data = await queryExpress();
      setCompanys(data);
    };
    getCompanys();
  }, []);

  const queryToSendFn = params => {
    const transformedParam = {
      ...params,
      logisticsStatus: props.type || 1,
      startTime: params.beginTime,
      pageNo: params.current,
      pageSize: params.pageSize || 20,
    };
    return queryToSend(transformedParam);
  };
  const searchRender = ({ searchText, resetText }, { form }) => [
    <Button
      key="search"
      type="primary"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.submit();
      }}
    >
      {searchText}
    </Button>,
    <Button
      key="rest"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.resetFields();
      }}
    >
      {resetText}
    </Button>,
  ];

  const toolBarRenderFn = () => [
    <Button
      type="primary"
      onClick={() => {
        if (ref.current) {
          const obj = { ...ref.current.getFieldsValue(), logisticsStatus: props.type || 1 };
          downOrder(obj);
        }
      }}
    >
      导出数据
    </Button>,
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={style.protable}
        actionRef={actionRef}
        request={params => queryToSendFn({ ...params })}
        columns={columns}
        rowKey={r => r.orderNo}
        formRef={ref}
        toolBarRender={toolBarRenderFn}
        search={{
          collapsed: false,
          optionRender: searchRender,
        }}
        bordered
        scroll={{ x: 1500 }}
      />
      <LogisticsForm
        onSubmit={reload}
        skuList={skuList}
        companys={companys}
        onCancel={() => handleModalVisible(false)}
        modalVisible={LogisticsModalVisible}
        value={LogisticsData}
      />
      <LogisticsCom
        onSubmit={reload}
        onCancel={() => handleComModalVisible(false)}
        modalVisible={LogisticsComModalVisible}
        value={LogisticsComList}
        key={LogisticsComList.key}
      />
    </PageHeaderWrapper>
  );
};

export default TableList;
