import request from '@/utils/request';
import config from '@/../config/env.config';

// import qs from 'qs';

const { roleApi, apiPrefix } = config;

/**
 * 获取企业客户列表
 * /yapi/project/389/interface/api/65324
 */
export async function apiEnterpriseList(data) {
  return request.post(`${apiPrefix}/enterprise/pageList`, {
    data,
    prefix: roleApi,
  });
}
/**
 * 获取企业客户详细
 * /yapi/project/389/interface/api/65339
 */
export async function apiEnterpriseInfo(id) {
  return request.get(`${apiPrefix}/enterprise/info?id=${id}`, {
    prefix: roleApi,
  });
}
/**
 * 添加企业客户
 * /yapi/project/389/interface/api/65329
 */
export async function apiNewEnterprise(data) {
  return request.post(`${apiPrefix}/enterprise/save`, {
    data,
    prefix: roleApi,
  });
}
/**
 * 编辑企业客户
 * /yapi/project/389/interface/api/65334
 */
export async function apiEditEnterprise(data) {
  return request.post(`${apiPrefix}/enterprise/update`, {
    data,
    prefix: roleApi,
  });
}

/**
 * 查询自提点列表
 * /yapi/project/389/interface/api/65494
 */
export async function apiEnterprisePickSelf() {
  return request.get(`${apiPrefix}/selfPickUpLocation/list`, {
    prefix: roleApi,
  });
}
