import request from '@/utils/request';
import config from '@/../config/env.config';

const { roleApi, apiPrefix } = config;
/**
 * 获取企业外卖商品列表
 * /yapi/project/389/interface/api/64794
 */
export async function apiTakeawayList(param) {
  const res = await request.post(`${apiPrefix}/product/enterprise/main/pageList`, {
    data: param,
    prefix: roleApi,
  });
  return res.data;
}
/**
 * 获取企业虚拟商品列表
 * /yapi/project/389/interface/api/64794
 */
export async function apiVirtualList(param) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/pageList`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业客户列表
 * /yapi/project/389/interface/api/65324
 */
export async function apiEnterpriseList(param) {
  return request.post(`${apiPrefix}/enterprise/pageList`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 模糊查询店铺列表
 * /yapi/project/389/interface/api/65289
 */
export async function apiShopList(param) {
  return request.post(`${apiPrefix}/shops/getListByName`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐-查询餐段配置
 * /yapi/project/389/interface/api/65444
 */
export async function apiMealTimePeriod(param) {
  return request.post(`${apiPrefix}/product/enterprise/getMealTimePeriod`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->信息修改
 * /yapi/project/389/interface/api/65099
 */
export async function apiMealInfoUpdate(param) {
  return request.post(`${apiPrefix}/product/enterprise/main/update`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->删除外卖商品
 * /yapi/project/389/interface/api/65109
 */
export async function apiTakeawayGoodsDel(param) {
  return request.post(`${apiPrefix}/product/enterprise/main/deleteById`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->删除虚拟商品
 * /yapi/project/389/interface/api/65109
 */
export async function apiVirtualGoodsDel(param) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/deleteById`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->查询自提点列表
 * /yapi/project/389/interface/api/65494
 */
export async function apiPickSelfList() {
  return request.get(`${apiPrefix}/selfPickUpLocation/list`, {
    prefix: roleApi,
  });
}
/**
 * 企业团餐->根据企业ID查询已选择自提点
 * /yapi/project/389/interface/api/65449
 */
export async function apiSelPickSelfList(param) {
  return request.post(`${apiPrefix}/product/enterprise/queryByEnterpriseId`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->查询外卖商品 - 选择商品弹窗
 * /yapi/project/389/interface/api/65479
 */
export async function apiSelGoodsList(param) {
  return request.post(`${apiPrefix}/product/enterprise/sku/page`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->查询商品 - 选择虚拟商品弹窗
 * /yapi/project/389/interface/api/65479
 */
export async function apiSelVirtualGoodsList(param) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/sku/page`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->添加外卖商品保存
 * /yapi/project/389/interface/api/65094
 */
export async function apiSaveGoodsList(param) {
  return request.post(`${apiPrefix}/product/enterprise/add`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->添加虚拟商品保存
 * /yapi/project/389/interface/api/65484
 */
export async function apiSaveVirtualGoodsList(param) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/add`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->虚拟品->根据企业ID查询店铺列表
 * /yapi/project/389/interface/api/65504
 */
export async function apiShopListByEnterpriseID(param) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/shops`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->根据企业ID+自提点列表查询店铺列表
 * /yapi/project/389/interface/api/65539
 */
export async function apiShopListByPickSelfID(param) {
  return request.post(`${apiPrefix}/product/enterprise/queryByEnterpriseIdAndPickSelfId`, {
    data: param,
    prefix: roleApi,
  });
}
/**
 * 企业团餐->根据企业ID 获取企业客户详细
 * /yapi/project/389/interface/api/65339
 */
export async function apiEnterpriseInfo(id) {
  return request.get(`${apiPrefix}/enterprise/info?id=${id}`, {
    prefix: roleApi,
  });
}
/**
 * 企业团餐->虚拟商品 校验是否可修改餐段和可售日期
 * /yapi/project/389/interface/api/65674
 */
export async function apiCheckInfo(data) {
  return request.post(`${apiPrefix}/product/enterprise/virtual/addParamCheck`, {
    data,
    prefix: roleApi,
  });
}
