/**
 * 数据模型转换-接口获取数据转换为表单数据
 */
export const transformVOToFormData = data => {
  const params = { ...data };
  if (params.authorizationUrl) {
    params.authorizationUrl = params.authorizationUrl.split(',');
  }
  if (params.horizontalLogo) {
    params.horizontalLogo = [params.horizontalLogo];
  }
  if (params.logo) {
    params.logo = [params.logo];
  }
  if (params.qualifyUrl) {
    params.qualifyUrl = params.qualifyUrl.split(',');
  }
  return params;
};

/*
 * 表单数据转换-表单数据转换为接口数据
 */
export const transformFormDataToDTO = res => {
  const params = { ...res };
  if (params.authorizationUrl?.length) {
    params.authorizationUrl = params.authorizationUrl.join(',');
  }
  if (params.horizontalLogo?.length) {
    params.horizontalLogo = params.horizontalLogo.join(',');
  }
  if (params.logo?.length) {
    params.logo = params.logo.join(',');
  }
  if (params.qualifyUrl?.length) {
    params.qualifyUrl = params.qualifyUrl.join(',');
  }
  return params;
};
