/**
 * 真实文件格式（前4个字节)
 */
export const ImgExt2Hex = {
  jpg: ['ffd8ffe0', 'ffd8ffe1', 'ffd8ffe2', 'ffd8ffe3'],
  jpeg: ['ffd8ffe0', 'ffd8ffe1', 'ffd8ffe2', 'ffd8ffe3'],
  png: ['89504e47'],
};

/**
 * 检测图片是否是预期的类型
 * @param {File} imgFile 图片文件对象
 * @param {string} imgExt 文件预期真实类型
 * @return {boolean} 文件类型是否和预期一致
 */
export const validImageType = (imgFile, imgExt) => {
  const FR = new FileReader();
  return new Promise(resolve => {
    FR.onload = e => {
      const { type } = imgFile;
      const correctExtHex = ImgExt2Hex[imgExt];
      const af = e.target.result;
      const view = new DataView(af);
      const first4Byte = view.getUint32(0, false); // 获取32bit数
      const hexValue = Number(first4Byte).toString(16);
      if (!type || !correctExtHex) {
        return resolve(false);
      }
      return resolve(correctExtHex.indexOf(hexValue) > -1);
    };
    FR.readAsArrayBuffer(imgFile);
  });
};
