import { Alert, Tabs } from 'antd';
import React, { Component } from 'react';
import { connect } from 'dva';
import LoginComponents from './components/Login';
import styles from './style.less';
import LoginSMS from './components/Login/LoginSms';

const { UserName, Password, Submit } = LoginComponents;

@connect(({ login, loading }) => ({
  userLogin: login,
  submitting: loading.effects['login/login'],
}))
class Login extends Component {
  loginForm = undefined;

  handleSubmit = (err, values) => {
    if (!err) {
      const { dispatch } = this.props;
      dispatch({
        type: 'login/login',
        payload: { ...values, tenantId: 560761, source: 1 },
      });
    }
  };

  renderMessage = content => (
    <Alert
      style={{
        marginBottom: 24,
      }}
      message={content}
      type="error"
      showIcon
    />
  );

  render() {
    const { userLogin, submitting } = this.props;
    const { status } = userLogin;
    return (
      <div className={styles.main}>
        <Tabs defaultActiveKey="1" destroyInactiveTabPane>
          <Tabs.TabPane tab={$t('account.login')} key="1">
            <LoginComponents
              onSubmit={this.handleSubmit}
              onCreate={form => {
                this.loginForm = form;
              }}
            >
              {status === 'error' &&
                !submitting &&
                this.renderMessage($t('wrong.usernamepassword'))}
              <UserName
                name="username"
                placeholder={`${$t('username')}`}
                rules={[
                  {
                    required: true,
                    message: $t('username.required'),
                  },
                ]}
              />
              <Password
                name="password"
                placeholder={`${$t('password')}`}
                rules={[
                  {
                    required: true,
                    message: $t('enter.password'),
                  },
                ]}
                onPressEnter={e => {
                  e.preventDefault();

                  if (this.loginForm) {
                    this.loginForm.validateFields(this.handleSubmit);
                  }
                }}
              />

              <Submit loading={submitting}>{$t('login')}</Submit>
            </LoginComponents>
          </Tabs.TabPane>
          {/* 后端短信模板还没申请下来 先隐藏 */}
          {/* <Tabs.TabPane tab="手机号登录" key="2">
            <LoginSMS loading={submitting} dispatch={this.props.dispatch} />
          </Tabs.TabPane> */}
        </Tabs>
      </div>
    );
  }
}

export default Login;
