import { Modal, Button, Table } from 'antd';
import React, { Component } from 'react';
import styles from '../style.less';

class fileModal extends Component {
  state = {
    imgModal: false,
    selectImg: '',
  };

  render() {
    const { visible, fileData = [] } = this.props;
    const imgData = fileData.filter(item => item.docType === 2);
    const tableData = fileData.filter(item => item.docType === 1);
    const tableColumns = [
      {
        title: $t('invoice.number'),
        dataIndex: 'invoiceNo',
      },
      {
        title: $t('tracking.number'),
        dataIndex: 'deliveryNo',
      },
    ];
    return (
      <Modal
        title={$t('attachment.details')}
        visible={visible}
        footer={null}
        onCancel={this.props.onCancel}
        width="700px"
      >
        <div className={styles.imgWrap}>
          {imgData.map(item => (
            <img
              onClick={() => {
                this.setState({ imgModal: true, selectImg: item.downloadUrl });
              }}
              key={item.id}
              width={200}
              alt=""
              src={item.downloadUrl}
              style={{ margin: 5 }}
            ></img>
          ))}
        </div>
        <Table
          pagination={{ pageSize: 5 }}
          dataSource={tableData}
          columns={tableColumns}
          rowKey={record => record.id}
          scroll={{ x: '100%', y: 300 }}
        />
        <Button type="primary" onClick={this.props.onCancel} className={styles.fileBtn}>{$t('close')}</Button>

        <Modal
          title={$t('attachment.details')}
          visible={this.state.imgModal}
          footer={null}
          onCancel={() => this.setState({ imgModal: false })}
          width="800px"
        >
          <img width="700px" src={this.state.selectImg} alt=""></img>
        </Modal>
      </Modal>
    );
  }
}

export default fileModal;
