import React, { useState, useEffect } from 'react';
import { Modal, Table, Button } from 'antd';
import { logColumn } from './staticData.js';
import { apiQueryModifyReceiverMobileLog } from '../../service';

/**
 * 更新收货人手机历史记录
 */
const ChangeLog = props => {
  const refForm = React.useRef();
  const { orderNo } = props;
  const [dataSource, setDataSource] = useState([]);

  const closeModal = v => {
    refForm?.current?.resetFields?.();
    !v && props.onClose(false);
  };

  const getDataSource = async () => {
    const res = await apiQueryModifyReceiverMobileLog(orderNo);
    if (res?.success) {
      setDataSource(res?.data?.records || []);
    }
  };

  useEffect(() => {
    if (props.visible) {
      getDataSource();
    }
  }, [props.visible]);

  return (
    props.visible && (
      <Modal
        open={props.visible}
        width={840}
        onCancel={() => closeModal(false)}
        footer={[
          <Button key="close" onClick={() => closeModal(false)}>{$t('close')}</Button>,
        ]}
      >
        <Table pagination={false} columns={logColumn} dataSource={dataSource} />
      </Modal>
    )
  );
};

export default ChangeLog;
