/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
import React, { useState, useEffect } from 'react';
import { Modal, Timeline } from 'antd';

const LogisticsCom = props => {
  const { modalVisible, onCancel } = props;
  const [result, setResult] = useState({});

  useEffect(() => {
    setResult(props.value);
  });
  return (
    <Modal
      destroyOnClose
      title={`${
        result?.expressCompanyName
          ? `${result?.expressCompanyName}-${result?.deliveryNo}`
          : '物流信息'
      }`}
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      afterClose={() => setResult({})}
      bodyStyle={{ maxHeight: '600px', minHeight: '200px', overflow: 'auto' }}
      footer={[]}
    >
      {result?.detailList?.length ? (
        <Timeline>
          {result?.detailList?.map((item, index) => (
            // eslint-disable-next-line react/no-array-index-key
            <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index}>
              <p>{item.desc}</p>
              <p>{item.time}</p>
            </Timeline.Item>
          ))}
        </Timeline>
      ) : (
        $t('no.logistics.info')
      )}
    </Modal>
  );
};

export default LogisticsCom;
