import React, { Component } from 'react';
import moment from 'moment';
import { ArrowRightOutlined, UploadOutlined } from '@ant-design/icons';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import {
  Select,
  Input,
  Radio,
  Checkbox,
  DatePicker,
  Upload,
  Button,
  Card,
  Row,
  Col,
  Cascader,
  notification,
  Spin,
  Tabs,
} from 'antd';
import styles from './style.less';
import {
  wrapperCol,
  uploadPropsFn,
  formItemLayout,
  renderServiceTags,
  loadData,
  getAreaAddr,
  getServiceFacility,
  businessModel,
  getInfo,
  // getBankList,
  businessTypeDesc,
  signDateTypeList,
  legalPersonList,
} from './data';
import { validatePhone, validateEMail, validNumber } from '@/utils/validator';
import { getErrorMessage } from '@/utils/utils';
import { apiCategoryList, apiEditStoreInfo, apiRecognize } from '../service';

const { Option } = Select;
const { Item: FormItem } = Form;
const carID = 301008; // 汽车类商家
const fileterBrandOptions = (input, options) => options.children.includes(input);
class BusinessInfo extends Component {
  getFieldDecorator = this.props?.form?.getFieldDecorator;

  setFieldsValue = this.props?.form?.setFieldsValue;

  state = {
    id: null,
    businessInfo: {
      customList: [],
      settlementType: 1,
      companyType: '',
    },
    areaAddr: [], // 四级地址列表
    categoryList: [], // 主要类目
    serviceFacilitys: [], // 服务设施
    // bankList: [], // 开户行
    settlementType: 1,
    // loading: false,
    visibleLoading: false,
    checkboxDisabled: false,
    mainCategoryId: null,
    companyNamedis: false, // 公司名称
    companyType: null, // 企业类型
    disabled: false, // 二期放开
  };

  async componentDidMount() {
    await getInfo.call(this);
    getAreaAddr.call(this);
    getServiceFacility.call(this);
    // getBankList.call(this);
  }

  // 主营类目
  onMainCategory(e) {
    this.setState({
      mainCategoryId: e,
    });
  }

  // 长期
  oncheckedChange = e => {
    const str = e.toString();
    this.setState({
      checkboxDisabled: str === $t('longterm'),
    });
    this.props.form.setFieldsValue({
      legalPersonEnd: '',
    });
  };

  // 计费类型改变
  onChangeCalculateType = (e, i) => {
    this.setState(state => {
      const { calculateType } = state;
      calculateType[i] = +e;
      return {
        calculateType,
      };
    });
  };

  static getDerivedStateFromProps() {
    return null;
  }

  // 帐号类型切换
  onChangeSettlType(e) {
    this.setState({
      settlementType: e,
    });
  }

  //  切换企业类型
  onChangeCompanyType = e => {
    const { value } = e.target;
    this.setState({
      companyType: value,
    });
    let type = null;
    if ([1, 3].includes(value)) {
      type = 1;
    } else {
      type = 2;
    }
    this.onChangeSettlType(type);
    this.props.form.setFieldsValue({
      settlementType: type,
    });
  };

  // 获取主营类目
  async getCategoryList(e) {
    const data = await apiCategoryList(e);
    if (!data.data) return;
    this.setState({ categoryList: data.data });
  }

  // 返回
  onCancel = () => {
    getInfo.call(this);
  };

  // 提交
  handleSubmit = e => {
    e.preventDefault();
    this.props.form.validateFields(async (err, values) => {
      const obj = Object.assign({}, values); // , this.state.businessInfo
      if (!err) {
        const imgs = this.state.businessInfo;
        // 营业执照
        // obj.businessLicensePeriod = `${moment(obj.businessLicensePeriodBegin).format(
        //   'YYYY-MM-DD',
        // )}-${moment(obj.businessLicensePeriodEnd).format('YYYY-MM-DD')}`;
        // 身份证有效期
        const legalPersonStart = moment(obj.legalPersonStart).format('YYYY/MM/DD');
        const legalPersonEnd = this.state.checkboxDisabled
          ? $t('longterm')
          : moment(obj.legalPersonEnd).format('YYYY/MM/DD');
        obj.legalPersonPeriod = `${legalPersonStart}-${legalPersonEnd}`;
        obj.facilities = {
          customList: this.state.businessInfo.customList,
          selfList: obj.selfList,
        };
        const areaArr = ['provinceId', 'cityId', 'countyId', 'townId'];
        obj.addr.forEach((item, i) => {
          obj[areaArr[i]] = item;
        });
        obj.accountOpenPermitImage =
          (imgs?.accountOpenPermitImage?.length && imgs.accountOpenPermitImage[0].url) || '';
        if (obj.supplierRateDTOList && obj.supplierRateDTOList.length) {
          obj.supplierRateDTOList.forEach(item => {
            if (item.ratedate && item.ratedate.length) {
              item.startDate = moment(item.ratedate[0]).format('YYYY-MM-DD');
              item.endDate = moment(item.ratedate[1]).format('YYYY-MM-DD');
              delete item.ratedate;
            }
          });
        }
        obj.businessLicenseImage =
          (imgs?.businessLicenseImage?.length && imgs?.businessLicenseImage[0].url) || '';
        obj.idCardEmblemImage =
          (imgs?.idCardEmblemImage?.length && imgs?.idCardEmblemImage[0].url) || '';
        obj.idCardPortraitImage =
          (imgs?.idCardPortraitImage?.length && imgs?.idCardPortraitImage[0].url) || '';
        obj.primaryImage = (imgs?.primaryImage?.length && imgs?.primaryImage[0].url) || '';
        obj.sealImage = (imgs?.sealImage?.length && imgs?.sealImage[0].url) || '';
        // 新增
        obj.brandCertificate =
          (imgs?.brandCertificate?.length && imgs?.brandCertificate[0]?.url) || '';
        obj.differentNameAuthorizationImage =
          (imgs?.differentNameAuthorizationImage?.length &&
            imgs?.differentNameAuthorizationImage[0]?.url) ||
          '';
        obj.householdRegisterImage =
          (imgs?.householdRegisterImage?.length && imgs?.householdRegisterImage[0]?.url) || '';
        if (!this.state.companyNamedis) {
          obj.icbProofImage = (imgs?.icbProofImage?.length && imgs?.icbProofImage[0]?.url) || '';
        } else {
          delete obj.icbProofImage;
        }

        obj.applySource = 1;
        obj.signDateType = 1;
        if (imgs.otherImage && imgs.otherImage.length) {
          obj.otherImage = imgs.otherImage.map(item => item.url);
        } else {
          delete obj.otherImage;
        }
        if (imgs.categoryQualificateImage && imgs.categoryQualificateImage.length) {
          const list = [];
          imgs.categoryQualificateImage.forEach(item => {
            list.push(item.url);
          });
          obj.categoryQualificateImage = list;
        } else {
          delete obj.categoryQualificateImage;
        }
        obj.legalPersonIdCard = obj.legalPersonIdCard?.toLocaleUpperCase() || '';
        obj.bankAccountLicenseNum = obj.bankAccountLicenseNum?.toLocaleUpperCase() || '';
        obj.socialCode = obj.socialCode?.toLocaleUpperCase() || '';
        obj.id = this.state.id;
        obj.headImage = obj.primaryImage;
        // this.setState({
        //   loading: true,
        // });
        const data = await apiEditStoreInfo(obj);
        if (data.businessCode === '0000') {
          notification.success({ message: `${data.msg}！～` });
        }
        // this.setState({
        //   loading: false,
        // });
      } else {
        const message = getErrorMessage(err);
        notification.warning({ message });
      }
    });
  };

  onSetPoint = e => {
    this.setFieldsValue({
      latitude: e.lat,
      longitude: e.lng,
    });
  };

  // 修改公司名称
  setCompanyName = () => {
    const val = this.state.companyNamedis;
    this.setState({
      companyNamedis: !val,
    });
    if (!val) {
      this.props.form.setFieldsValue({
        companyName: this.state.businessInfo.companyName,
        icbProofImage: '',
        householdRegisterImage: '',
      });
    }
  };

  onChangeBusinessModel = e => {
    this.getCategoryList(e);
    this.props.form.setFieldsValue({
      mainCategoryId: '',
    });
  };

  /* eslint-disable no-return-assign */
  saveInputRef = input => (this.input = input);

  // 处理图片
  dealImgInfo = async (type, url) => {
    const imgType = {
      businessLicenseImage: 2,
      idCardPortraitImage: 5,
      idCardEmblemImage: 4,
    };
    if (!url) {
      return;
    }
    this.setState({
      visibleLoading: true,
    });
    const data = await apiRecognize({
      imageUrl: url,
      imageType: imgType[type],
    });
    if (data.businessCode === '0000') {
      const res = data.data;
      const info = {};
      this.setState(state => {
        if (type === 'businessLicenseImage') {
          info.socialCode = res.socialCode || '';
          info.companyName = res.companyName || '';
          info.businessLicensePeriod = res.businessLicensePeriodBegin;
          if (res.businessLicensePeriodEnd) {
            if (info.businessLicensePeriod) {
              info.businessLicensePeriod += '-';
            }
            info.businessLicensePeriod += res.businessLicensePeriodEnd;
          }
          // info.businessLicensePeriodBegin = res.businessLicensePeriodBegin
          //   ? moment(res.businessLicensePeriodBegin)
          //   : '';
          // info.businessLicensePeriodEnd = res.businessLicensePeriodEnd
          //   ? moment(res.businessLicensePeriodEnd)
          //   : '';
        } else if (type === 'idCardPortraitImage') {
          info.legalPersonName = res.legalPersonName || '';
          info.legalPersonIdCard = res.legalPersonIdCard || '';
        } else if (type === 'idCardEmblemImage' && res.legalPersonPeriod) {
          // 身份证有效期处理
          const date = res.legalPersonPeriod.split('-') || [];
          info.legalPersonStart = date[0] && moment(date[0]);
          info.legalPersonEnd = date[1] && date[1] !== $t('longterm') ? moment(date[1]) : '';
          info.checked = date[1] && date[1] === $t('longterm') ? [$t('longterm')] : [];
          const checkboxDisabled = date[1] && date[1] === $t('longterm');
          this.setState({
            checkboxDisabled,
          });
          // info.legalPersonPeriod = res.legalPersonPeriod
          //   .replace(/\./g, '/')
          //   .split('-')
          //   .map(o => moment(o));
        }
        return {
          businessInfo: Object.assign(state.businessInfo, info),
        };
      });
      this.props.form.setFieldsValue({
        ...info,
      });
    } else {
      notification.error({ message: data.msg });
    }
    this.setState({
      visibleLoading: false,
    });
  };

  render() {
    const {
      form: { getFieldDecorator },
    } = this.props;
    const {
      businessInfo,
      type,
      checkboxDisabled,
      mainCategoryId,
      companyNamedis,
      companyType,
      disabled,
    } = this.state;
    return (
      <div className={styles.infoBox}>
        <Form className="login-form" onSubmit={this.handleSubmit} {...formItemLayout}>
          <Card title={$t('store.basic.info')}>
            <Row gutter={24}>
              <Col span={24}>
                <FormItem label={$t('business.model')} labelCol={{ span: 4 }}>
                  {getFieldDecorator('productBusiness', {
                    rules: [{ required: true, message: $t('business.model.required') }],
                    initialValue: businessInfo.productBusiness,
                  })(
                    <Checkbox.Group
                      options={businessModel}
                      onChange={e => this.onChangeBusinessModel(e)}
                      disabled={+mainCategoryId === carID || disabled}
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label={$t('main.category')} labelCol={{ span: 4 }}>
                  {getFieldDecorator('mainCategoryId', {
                    rules: [{ required: true, message: $t('select.main.category') }],
                    initialValue: businessInfo.mainCategoryId,
                  })(
                    <Select
                      onChange={e => this.onMainCategory(e)}
                      showSearch
                      filterOption={(input, option) =>
                        option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                      }
                      disabled={+businessInfo.mainCategoryId === 301008 || disabled}
                    >
                      {this.state.categoryList.map(item => (
                        <Option value={item.id} key={item.id}>
                          {item.name}
                        </Option>
                      ))}
                    </Select>,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label={$t('store.name')} labelCol={{ span: 4 }}>
                  {getFieldDecorator('name', {
                    rules: [{ required: true, message: $t('enter.merchant.name') }],
                    initialValue: businessInfo.name,
                  })(<Input maxLength={32} disabled={disabled} />)}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label={$t('store.region')} labelCol={{ span: 4 }}>
                  {getFieldDecorator('addr', {
                    rules: [{ required: true, type: 'array', message: $t('store.area.required') }],
                    initialValue: businessInfo.addr,
                  })(
                    <Cascader
                      options={this.state.areaAddr}
                      loadData={e => loadData.call(this, e)}
                      changeOnSelect
                      disabled={disabled}
                    />,
                  )}
                </FormItem>
              </Col>
              <Col span={24}>
                <FormItem label={$t('business.address')} labelCol={{ span: 4 }}>
                  {getFieldDecorator('detailAddress', {
                    rules: [{ required: true, message: $t('enter.business.address') }],
                    initialValue: businessInfo.detailAddress,
                  })(<Input maxLength={500} disabled={disabled} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label={$t('contact.name')} labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactName', {
                    rules: [
                      { required: true, message: $t('contact.name.required') },
                      { pattern: /^[A-Za-z\u4e00-\u9fa5]+$/, message: $t('chineseletters.only') },
                    ],
                    initialValue: businessInfo.contactName,
                  })(<Input disabled={disabled} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label={$t('contact.phone')} labelCol={{ span: 5 }}>
                  {getFieldDecorator('contactPhone', {
                    rules: [
                      { required: true, message: $t('enter.contact.phone') },
                      { validator: validatePhone, message: $t('valid.phone.required') },
                    ],
                    initialValue: businessInfo.contactPhone,
                  })(<Input maxLength={11} disabled={disabled} />)}
                </FormItem>
              </Col>
              <Col span={12}>
                <FormItem label={$t('contact.email')} labelCol={{ span: 8 }}>
                  {getFieldDecorator('contactEmail', {
                    rules: [
                      { required: true, message: $t('enter.contact.email') },
                      { validator: validateEMail, message: $t('valid.email.required') },
                    ],
                    initialValue: businessInfo.contactEmail,
                  })(<Input disabled={disabled} />)}
                </FormItem>
              </Col>
              {+mainCategoryId !== carID && (
                <>
                  <Col span={12}>
                    <FormItem label={$t('customer.service.hotline')} labelCol={{ span: 5 }}>
                      {getFieldDecorator('servicePhone', {
                        rules: [{ required: true, message: $t('enter.service.hotline') }],
                        initialValue: businessInfo.servicePhone,
                      })(<Input maxLength={11} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={24}>
                    <FormItem label={$t('signing.date')} labelCol={{ span: 4 }}>
                      {getFieldDecorator('signDateType', {
                        rules: [{ required: true, message: $t('select.contract.date') }],
                        initialValue: businessInfo.signDateType,
                      })(<Checkbox.Group options={signDateTypeList} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                </>
              )}
            </Row>
          </Card>
          <Card title={$t('store.business.info')}>
            <Col span={12} className={styles.imgList}>
              <FormItem label={$t('store.header.image')} labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                {getFieldDecorator('primaryImage', {
                  rules: [{ required: true, message: $t('upload.merchant.header') }],
                  initialValue: businessInfo.primaryImage,
                })(
                  <Upload
                    {...uploadPropsFn.call(this, { keyName: 'primaryImage', type: 1 })}
                    fileList={businessInfo.primaryImage}
                    disabled={disabled}
                  >
                    <UploadOutlined />{$t('upload.file')}</Upload>,
                )}
              </FormItem>
            </Col>
            {+mainCategoryId !== carID && (
              <>
                <Col span={24}>
                  <FormItem label={$t('service.facility')} labelCol={{ span: 4 }}>
                    {getFieldDecorator('selfList', {
                      initialValue: businessInfo.selfList,
                    })(
                      <Select
                        mode="multiple"
                        filterOption={fileterBrandOptions}
                        disabled={disabled}
                      >
                        {this.state.serviceFacilitys.map(item => (
                          <Option value={item.code} key={item.code}>
                            {item.desc}
                          </Option>
                        ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <Col span={24}>
                  <FormItem label={$t('custom.service.facility')} labelCol={{ span: 4 }}>
                    {getFieldDecorator('customList', {
                      initialValue: businessInfo.customList,
                    })(renderServiceTags.call(this))}
                  </FormItem>
                </Col>
              </>
            )}
          </Card>
          <Card title={$t('license.info.entry')}>
            <Row gutter={24}>
              {+mainCategoryId !== carID && (
                <Col span={24}>
                  <FormItem label={$t('enterprise.type')} labelCol={{ span: 4 }}>
                    {getFieldDecorator('companyType', {
                      rules: [{ required: true, message: $t('select.company.type') }],
                      initialValue: businessInfo.companyType,
                    })(
                      <Radio.Group
                        onChange={this.onChangeCompanyType}
                        disabled={businessInfo.companyType || disabled}
                      >
                        <Radio value={1}>{$t('general.taxpayer')}</Radio>
                        <Radio value={2}>{$t('smallscale')}</Radio>
                        <Radio value={3}>{$t('individual.business')}</Radio>
                      </Radio.Group>,
                    )}
                  </FormItem>
                </Col>
              )}

              <Col span={24} className={styles.imgList}>
                <FormItem label={$t('business.license')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                  {getFieldDecorator('businessLicenseImage', {
                    rules: [{ required: true, message: $t('upload.business.license') }],
                    initialValue: businessInfo.businessLicenseImage,
                  })(
                    <Upload
                      {...uploadPropsFn.call(
                        this,
                        { keyName: 'businessLicenseImage', type: 2 },
                        this.dealImgInfo,
                      )}
                      fileList={businessInfo.businessLicenseImage}
                      disabled={disabled}
                    >
                      <UploadOutlined />{$t('upload.file')}</Upload>,
                  )}
                </FormItem>
              </Col>
              {+mainCategoryId !== carID && (
                <>
                  <Col span={12}>
                    <Row>
                      <Col span={4} style={{ marginTop: '4px' }}>
                        {/* 二期放开 */}
                        {businessInfo.companyName && (
                          <Button onClick={this.setCompanyName}>
                            {this.state.companyNamedis ? $t('edit') : $t('cancel')}
                          </Button>
                        )}
                      </Col>
                      <Col span={12}>
                        <FormItem label={$t('company.name')} labelCol={{ span: 8 }}>
                          {getFieldDecorator('companyName', {
                            rules: [{ required: true, message: $t('enter.company.name') }],
                            initialValue: businessInfo.companyName,
                          })(<Input maxLength={50} disabled={companyNamedis || disabled} />)}
                        </FormItem>
                      </Col>
                    </Row>
                  </Col>
                  <Col span={12}>
                    <FormItem label={$t('unified.social.credit.code')} labelCol={{ span: 8 }}>
                      {getFieldDecorator('socialCode', {
                        rules: [
                          { required: true, message: $t('enter.credit.code') },
                          { pattern: /^[A-Za-z0-9]*$/, message: $t('only.numbers.and.letters.allowed') },
                        ],
                        initialValue: businessInfo.socialCode,
                      })(<Input maxLength={18} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  {(!companyNamedis &&
                    businessInfo.companyType &&
                    businessInfo.companyType !== 2) ||
                  (!companyNamedis && businessInfo?.icbProofImage?.length) ? (
                    <Col span={12}>
                      <FormItem
                        label={$t('business.license.change.proof')}
                        labelCol={{ span: 8 }}
                        wrapperCol={wrapperCol}
                      >
                        {getFieldDecorator('icbProofImage', {
                          rules: [{ required: true, message: $t('upload.business.change.proof') }],
                          initialValue: businessInfo.icbProofImage,
                        })(
                          <Upload
                            {...uploadPropsFn.call(this, {
                              keyName: 'icbProofImage',
                              limit: 1,
                            })}
                            fileList={businessInfo.icbProofImage}
                            disabled={disabled}
                          >
                            <UploadOutlined />{$t('upload.file')}</Upload>,
                        )}
                      </FormItem>
                    </Col>
                  ) : (
                    ''
                  )}
                  {(!companyNamedis &&
                    businessInfo.companyType &&
                    businessInfo.companyType === 2) ||
                  (!companyNamedis && businessInfo?.householdRegisterImage?.length) ? (
                    <Col span={12}>
                      <FormItem label={$t('household.register.page')} labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                        {getFieldDecorator('householdRegisterImage', {
                          rules: [{ required: true, message: $t('upload.household.register') }],
                          initialValue: businessInfo.householdRegisterImage,
                        })(
                          <Upload
                            {...uploadPropsFn.call(this, {
                              keyName: 'householdRegisterImage',
                              limit: 1,
                            })}
                            fileList={businessInfo.householdRegisterImage}
                            disabled={disabled}
                          >
                            <UploadOutlined />{$t('upload.file')}</Upload>,
                        )}
                      </FormItem>
                    </Col>
                  ) : (
                    ''
                  )}
                  <Col span={24}>
                    <FormItem label={$t('license.validity')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                      {getFieldDecorator('businessLicensePeriod', {
                        rules: [{ required: true, message: $t('license.expiry.required') }],
                        initialValue: businessInfo.businessLicensePeriod,
                      })(
                        <Input
                          style={{ width: '200px' }}
                          placeholder={$t('enter.license.expiry')}
                          disabled={disabled}
                        />,
                      )}
                    </FormItem>
                  </Col>
                  {/* <Col span={12}>
                    <FormItem
                      label="营业执照执照结束日期"
                      labelCol={{ span: 12 }}
                      wrapperCol={{ span: 12 }}
                    >
                      {getFieldDecorator('businessLicensePeriodEnd', {
                        rules: [{ required: true, message: '请选择营业执照结束日期!' }],
                        initialValue: businessInfo.businessLicensePeriodEnd,
                      })(
                        <DatePicker
                          style={{ width: '200px' }}
                          placeholder="请选择营业执照结束日期"
                          disabled={disabled}
                        />,
                      )}
                    </FormItem>
                  </Col> */}
                  <Col span={24}>
                    <FormItem label={$t('category.qualifications')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                      {getFieldDecorator('categoryQualificateImage', {
                        initialValue: businessInfo.categoryQualificateImage,
                      })(
                        <Upload
                          {...uploadPropsFn.call(this, {
                            keyName: 'categoryQualificateImage',
                            type: 6,
                            limit: 9,
                          })}
                          fileList={businessInfo.categoryQualificateImage}
                          disabled={disabled}
                        >
                          <UploadOutlined />{$t('upload.file')}</Upload>,
                      )}
                    </FormItem>
                  </Col>
                  <Col span={24}>
                    <FormItem label={$t('esignature')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                      {getFieldDecorator('sealImage', {
                        rules: [{ required: true, message: $t('upload.esignature') }],
                        initialValue: businessInfo.sealImage,
                      })(
                        <Upload
                          {...uploadPropsFn.call(this, {
                            keyName: 'sealImage',
                            type: 3,
                            maxSize: 1024 * 200,
                            maxSizeMsg: $t('max.file.size.200k'),
                            limit: 1,
                          })}
                          fileList={businessInfo.sealImage}
                          disabled={disabled}
                        >
                          <UploadOutlined />{$t('upload.file')}</Upload>,
                      )}
                    </FormItem>
                  </Col>
                </>
              )}
              {+mainCategoryId === carID && (
                <>
                  <Col span={24}>
                    <FormItem label={$t('authorized.brand')} labelCol={{ span: 4 }}>
                      {getFieldDecorator('brand', {
                        rules: [{ required: true, message: $t('enter.authorized.brand') }],
                        initialValue: businessInfo.brand,
                      })(<Input maxLength={32} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={24}>
                    <FormItem
                      label={$t('brand.distributor.license')}
                      labelCol={{ span: 4 }}
                      wrapperCol={wrapperCol}
                    >
                      {getFieldDecorator('brandCertificate', {
                        rules: [{ required: true, message: $t('upload.brand.authorization') }],
                        initialValue: businessInfo.brandCertificate,
                      })(
                        <Upload
                          {...uploadPropsFn.call(this, {
                            keyName: 'brandCertificate',
                            limit: 1,
                          })}
                          fileList={businessInfo.brandCertificate}
                          disabled={disabled}
                        >
                          <UploadOutlined />{$t('upload.file')}</Upload>,
                      )}
                    </FormItem>
                  </Col>
                </>
              )}
            </Row>
          </Card>
          <Card title={$t('legal.info.entry')}>
            <Row gutter={24}>
              {+mainCategoryId !== carID && (
                <>
                  <Col span={12} className={styles.imgList}>
                    <FormItem
                      label={$t('legal.id.front')}
                      labelCol={{ span: 8 }}
                      wrapperCol={wrapperCol}
                    >
                      {getFieldDecorator('idCardPortraitImage', {
                        rules: [{ required: true, message: $t('upload.id.front') }],
                        initialValue: businessInfo.idCardPortraitImage,
                      })(
                        <Upload
                          {...uploadPropsFn.call(
                            this,
                            { keyName: 'idCardPortraitImage', type: 5 },
                            this.dealImgInfo,
                          )}
                          fileList={businessInfo.idCardPortraitImage}
                          disabled={disabled}
                        >
                          <UploadOutlined />
                          <div>{$t('id.front')}</div>
                        </Upload>,
                      )}
                    </FormItem>
                  </Col>
                  <Col span={12} className={styles.imgList}>
                    <FormItem
                      label={$t('legal.id.back')}
                      labelCol={{ span: 8 }}
                      wrapperCol={wrapperCol}
                    >
                      {getFieldDecorator('idCardEmblemImage', {
                        rules: [{ required: true, message: $t('upload.id.back') }],
                        initialValue: businessInfo.idCardEmblemImage,
                      })(
                        <Upload
                          {...uploadPropsFn.call(
                            this,
                            { keyName: 'idCardEmblemImage', type: 4 },
                            this.dealImgInfo,
                          )}
                          fileList={businessInfo.idCardEmblemImage}
                          disabled={disabled}
                        >
                          <UploadOutlined />
                          <div>{$t('id.back')}</div>
                        </Upload>,
                      )}
                    </FormItem>
                  </Col>
                  <Col span={12}>
                    <FormItem label={$t('id.name')} labelCol={{ span: 8 }}>
                      {getFieldDecorator('legalPersonName', {
                        rules: [{ required: true, message: $t('enter.id.name') }],
                        initialValue: businessInfo.legalPersonName,
                      })(<Input maxLength={8} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={12}>
                    <FormItem label={$t('id.number')} labelCol={{ span: 8 }}>
                      {getFieldDecorator('legalPersonIdCard', {
                        rules: [
                          { required: true, message: $t('enter.id.number') },
                          { pattern: /^[A-Za-z0-9]*$/, message: $t('numbers.or.letters') },
                        ],
                        initialValue: businessInfo.legalPersonIdCard,
                      })(<Input maxLength={18} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={12}>
                    <FormItem label={$t('id.expiry.start')} labelCol={{ span: 8 }}>
                      {getFieldDecorator('legalPersonStart', {
                        rules: [{ required: true, message: $t('id.expiry.start.required') }],
                        initialValue: businessInfo.legalPersonStart,
                      })(<DatePicker style={{ width: '200px' }} disabled={disabled} />)}
                    </FormItem>
                  </Col>
                  <Col span={12}>
                    <Row gutter={24}>
                      <Col span={19}>
                        <FormItem
                          label={$t('id.expiry.end')}
                          labelCol={{ span: 12 }}
                          wrapperCol={{ span: 12 }}
                        >
                          {getFieldDecorator('legalPersonEnd', {
                            rules: [{ required: !checkboxDisabled, message: $t('id.expiry.end.required') }],
                            initialValue: businessInfo.legalPersonEnd,
                          })(
                            <DatePicker
                              style={{ width: '200px' }}
                              disabled={checkboxDisabled || disabled}
                            />,
                          )}
                        </FormItem>
                      </Col>
                      <Col span={5}>
                        <FormItem>
                          {getFieldDecorator('checked', {
                            initialValue: businessInfo.checked,
                          })(
                            <Checkbox.Group
                              options={legalPersonList}
                              className={styles.radio}
                              onChange={e => this.oncheckedChange(e)}
                              disabled={disabled}
                            />,
                          )}
                        </FormItem>
                      </Col>
                    </Row>
                  </Col>
                </>
              )}
              <Col span={12}>
                <FormItem label={$t('phone.number')} labelCol={{ span: 8 }}>
                  {getFieldDecorator('legalPersonPhone', {
                    rules: [
                      { required: true, message: $t('phone.required') },
                      { validator: validatePhone, message: $t('valid.phone.required') },
                    ],
                    initialValue: businessInfo.legalPersonPhone,
                  })(<Input maxLength={11} disabled={disabled} />)}
                </FormItem>
              </Col>
              {+mainCategoryId !== carID && (
                <Col span={24}>
                  <FormItem label={$t('other.certificates')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('otherImage', {
                      initialValue: businessInfo.otherImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, { keyName: 'otherImage', limit: 9, type: 7 })}
                        fileList={businessInfo.otherImage}
                        disabled={disabled}
                      >
                        <UploadOutlined />{$t('upload.file')}</Upload>,
                    )}
                  </FormItem>
                </Col>
              )}
            </Row>
          </Card>
          <Card title={$t('settlement.info.entry')}>
            {+mainCategoryId !== carID && (
              <>
                <Row gutter={24}>
                  <Col span={24}>
                    <FormItem label={$t('account.type')} labelCol={{ span: 4 }} wrapperCol={wrapperCol}>
                      {getFieldDecorator('settlementType', {
                        rules: [{ required: true, message: $t('select.account.type') }],
                        initialValue: businessInfo.settlementType,
                      })(
                        <Radio.Group
                          onChange={e => this.onChangeSettlType(e?.target?.value)}
                          disabled={disabled}
                        >
                          <Radio value={1} disabled={[2].includes(companyType)}>{$t('corporate')}</Radio>
                          <Radio value={2} disabled={[1, 3].includes(companyType)}>{$t('individual')}</Radio>
                        </Radio.Group>,
                      )}
                    </FormItem>
                  </Col>
                </Row>
                {this.state.settlementType === 1 && (
                  <Row gutter={24}>
                    <Col span={12}>
                      <FormItem label={$t('bank.license')} labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                        {getFieldDecorator('accountOpenPermitImage', {
                          rules: [{ required: true, message: $t('upload.account.license') }],
                          initialValue: businessInfo.accountOpenPermitImage,
                        })(
                          <Upload
                            {...uploadPropsFn.call(this, {
                              keyName: 'accountOpenPermitImage',
                              type: 8,
                            })}
                            fileList={businessInfo.accountOpenPermitImage}
                            disabled={disabled}
                          >
                            <UploadOutlined />{$t('upload.file')}</Upload>,
                        )}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank.license.number')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccountLicenseNum', {
                          rules: [
                            { required: true, message: $t('enter.license.number') },
                            { pattern: /^[A-Za-z0-9]*$/, message: $t('numbers.or.letters') },
                          ],
                          initialValue: businessInfo.bankAccountLicenseNum,
                        })(<Input disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('account.name')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccountName', {
                          rules: [{ required: true, message: $t('enter.account.name') }],
                          initialValue: businessInfo.bankAccountName,
                        })(<Input maxLength={32} disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('accountBankName', {
                          rules: [{ required: true, message: $t('enter.bank.name') }],
                          initialValue: businessInfo.accountBankName,
                        })(<Input maxLength={100} disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank.account')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccount', {
                          rules: [
                            { required: true, message: $t('enter.bank.account') },
                            { pattern: /^[0-9]*$/, message: $t('numbers.required') },
                          ],
                          initialValue: businessInfo.bankAccount,
                        })(<Input disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank.routing.no')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('interbankNum', {
                          rules: [{ pattern: /^[0-9]*$/, message: $t('numbers.required') }],
                          initialValue: businessInfo.interbankNum,
                        })(<Input maxLength={50} disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={24}>
                      <FormItem
                        label={$t('nonmatching.settlement.auth.file')}
                        labelCol={{ span: 4 }}
                        wrapperCol={wrapperCol}
                      >
                        {getFieldDecorator('differentNameAuthorizationImage', {
                          initialValue: businessInfo.differentNameAuthorizationImage,
                        })(
                          <Upload
                            {...uploadPropsFn.call(this, {
                              keyName: 'differentNameAuthorizationImage',
                              limit: 1,
                            })}
                            fileList={businessInfo.differentNameAuthorizationImage}
                            disabled={disabled}
                          >
                            <UploadOutlined />{$t('upload.file')}</Upload>,
                        )}
                      </FormItem>
                    </Col>
                  </Row>
                )}
                {this.state.settlementType === 2 && (
                  <Row gutter={24}>
                    <Col span={12}>
                      <FormItem label={$t('bank.card.type')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccountType', {
                          rules: [{ required: true, message: $t('select.bank.card.type') }],
                          initialValue: businessInfo.bankAccountType,
                        })(
                          <Select disabled={disabled}>
                            <Option value={1} key={1}>{$t('debit.card')}</Option>
                          </Select>,
                        )}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('account.name')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccountName', {
                          rules: [{ required: true, message: $t('enter.account.name') }],
                          initialValue: businessInfo.bankAccountName,
                        })(<Input maxLength={32} disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('accountBankName', {
                          rules: [{ required: true, message: $t('enter.bank.name') }],
                          initialValue: businessInfo.accountBankName,
                        })(<Input maxLength={100} disabled={disabled} />)}
                      </FormItem>
                    </Col>
                    <Col span={12}>
                      <FormItem label={$t('bank.account')} labelCol={{ span: 8 }}>
                        {getFieldDecorator('bankAccount', {
                          rules: [
                            { required: true, message: $t('enter.bank.account') },
                            { pattern: /^[0-9]*$/, message: $t('numbers.required') },
                          ],
                          initialValue: businessInfo.bankAccount,
                        })(<Input disabled={disabled} />)}
                      </FormItem>
                    </Col>
                  </Row>
                )}
              </>
            )}
            {+mainCategoryId === carID && (
              <Row gutter={24}>
                <Col span={12}>
                  <FormItem label={$t('bank.license')} labelCol={{ span: 8 }} wrapperCol={wrapperCol}>
                    {getFieldDecorator('accountOpenPermitImage', {
                      rules: [{ required: true, message: $t('upload.account.license') }],
                      initialValue: businessInfo.accountOpenPermitImage,
                    })(
                      <Upload
                        {...uploadPropsFn.call(this, {
                          keyName: 'accountOpenPermitImage',
                          type: 8,
                        })}
                        fileList={businessInfo.accountOpenPermitImage}
                        disabled={disabled}
                      >
                        <UploadOutlined />{$t('upload.file')}</Upload>,
                    )}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label={$t('account.name')} labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccountName', {
                      rules: [{ required: true, message: $t('enter.account.name') }],
                      initialValue: businessInfo.bankAccountName,
                    })(<Input maxLength={32} disabled={disabled} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label={$t('bank')} labelCol={{ span: 8 }}>
                    {getFieldDecorator('accountBankName', {
                      rules: [{ required: true, message: $t('enter.bank.name') }],
                      initialValue: businessInfo.accountBankName,
                    })(<Input maxLength={100} disabled={disabled} />)}
                  </FormItem>
                </Col>
                <Col span={12}>
                  <FormItem label={$t('bank.account')} labelCol={{ span: 8 }}>
                    {getFieldDecorator('bankAccount', {
                      rules: [
                        { required: true, message: $t('enter.bank.account') },
                        { pattern: /^[0-9]*$/, message: $t('numbers.required') },
                      ],
                      initialValue: businessInfo.bankAccount,
                    })(<Input disabled={disabled} />)}
                  </FormItem>
                </Col>
              </Row>
            )}
          </Card>
          {+mainCategoryId === carID && (
            <Card title={$t('other.info')}>
              <Row gutter={24}>
                <Col span={24}>
                  <FormItem label={$t('gift.content')} labelCol={{ span: 4 }}>
                    {getFieldDecorator('giftPackageContent', {
                      rules: [{ required: true, message: $t('enter.gift.content') }],
                      initialValue: businessInfo.giftPackageContent,
                    })(<Input style={{ width: '50%' }} disabled={disabled} />)}
                  </FormItem>
                </Col>
              </Row>
            </Card>
          )}
          {/* 临时注释二期放开 */}
          <div className={styles.formBtns}>
            <Button type="primary" size="large" htmlType="submit" loading={this.state.loading}>{$t('edit.and.submit')}</Button>
            <Button size="large" onClick={this.onCancel}>{$t('cancel')}</Button>
          </div>
        </Form>
        {this.state.visibleLoading && (
          <div className={styles.spinBox}>
            <div className={styles.spinBoxWrapper}>
              <Spin tip="Loading..." />
            </div>
          </div>
        )}
      </div>
    );
  }
}
export default Form.create()(BusinessInfo);
