import React from 'react';
import { Button, Space, Switch } from 'antd';
import { FormOutlined } from '@ant-design/icons';
import { getShopList } from '../service/bll';
import style from '../style/index.less';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};
// 餐段 0-推荐 1-早餐 2-午餐 3-下午茶 4-晚餐
export const mealColumn = {
  // 0: '推荐',
  1: $t('breakfast'),
  2: $t('lunch'),
  // 3: '晚餐',
  4: $t('dinner'),
};

// 商品类型
export const productType = {
  1: $t('physical.goods'),
  2: $t('virtual.product'),
  // 3: '电子卡券'（废弃）
  4: $t('service.products'),
  5: $t('delivery.products'),
};

// 餐品类型：（1外卖 2 自助餐 4到店）
export const mealType = {
  1: $t('takeaway'),
  2: $t('buffet'),
  4: $t('instore'),
};

export const weekOptions = {
  1: $t('monday'),
  2: $t('tuesday'),
  3: $t('wednesday'),
  4: $t('thursday'),
  5: $t('friday'),
  6: $t('saturday'),
  7: $t('sunday'),
};

// 外卖商品列表字段
export const takeawayGoodsColumn = options => {
  const {
    onDel,
    onChangeFlag,
    setVisibleSaleDate,
    enterprises,
    enterpriseId,
    setRecordID,
    setEditItem,
    setVisiblePrice,
    setVisibleSaleSection,
    setVisibleSort,
    onChangeEnterprise,
  } = options;
  return [
    {
      title: $t('enterprise.name'),
      dataIndex: 'enterpriseId',
      hideInTable: true,
      valueType: 'select',
      fieldProps: {
        value: enterpriseId ? +enterpriseId : null,
        showSearch: true,
        filterOption: (v, option) => (option?.label ?? '').toLowerCase().includes(v.toLowerCase()),
        onChange: onChangeEnterprise,
        options: enterprises,
        allowClear: false,
      },
    },
    {
      title: $t('westore.name'),
      dataIndex: 'shopId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: false,
        // onSearch: getShopList,
      },
      request: getShopList,
      valueEnum: {},
    },
    {
      title: $t('westore.name'),
      dataIndex: 'shopName',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('sku.code'),
      dataIndex: 'skuId',
      width: 170,
      align: 'center',
    },
    {
      title: $t('product.name'),
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: $t('product.image'),
      dataIndex: 'primaryImage',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueType: 'image',
    },
    {
      title: $t('available.date'),
      dataIndex: 'saleDateList',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length ? (
            <div>
              {_.length === 7 ? $t('no.restriction') : <span>{_.map(item => item.name).join('/')}</span>}
            </div>
          ) : (
            <span>-</span>
          )}
          <span
            className={style.columnBtnEdit}
            onClick={() => {
              setRecordID(record.id);
              setEditItem(record);
              setVisibleSaleDate(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('available.meal.period'),
      dataIndex: 'tabCateList',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length ? (
            <span>
              {_.sort((x, y) => x.tabId - y.tabId)
                .map(item => item.tabName)
                .join('/')}
            </span>
          ) : (
            <span>-</span>
          )}
          <span
            className={style.columnBtnEdit}
            onClick={() => {
              setRecordID(record.id);
              setEditItem(record);
              setVisibleSaleSection(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('enterprise.price'),
      dataIndex: 'activityPrice',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span
            className={style.columnBtnEdit}
            onClick={() => {
              setRecordID(record.id);
              setEditItem(record);
              setVisiblePrice(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('product.sales.price'),
      dataIndex: 'price',
      width: 100,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueEnum: {
        1: $t('listed'),
        2: $t('delisted'),
        3: $t('sold.out'),
      },
    },
    {
      title: $t('sort'),
      dataIndex: 'sort',
      width: 90,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span
            className={style.columnBtnEdit}
            onClick={() => {
              setRecordID(record.id);
              setEditItem(record);
              setVisibleSort(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('list.products'),
      dataIndex: 'showFlag',
      align: 'center',
      width: 100,
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>
            <Switch checked={+_ === 1} onChange={e => onChangeFlag(record.id, e)} />
          </span>
        </Space>
      ),
    },
    {
      title: $t('food.type'),
      dataIndex: 'mealTypeList',
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: $t('add.time'),
      dataIndex: 'createDate',
      valueType: 'dateRange',
      align: 'center',
      render(v, record) {
        return record.createDate;
      },
    },
    {
      title: $t('available.meal.period'),
      dataIndex: 'tabId',
      align: 'center',
      valueEnum: mealColumn,
      hideInTable: true,
    },
    {
      title: $t('actions'),
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r.id)}>{$t('delete')}</Button>
      ),
    },
  ];
};

// 添加商品列表字段
export const GoodsInfoColumn = options => {
  const {
    onDel,
    setVisibleSaleDate,
    setVisibleSaleSection,
    setEditItem,
    setVisiblePrice,
  } = options;
  return [
    {
      title: $t('westore.name'),
      dataIndex: 'shopName',
    },
    {
      title: $t('product.name'),
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: $t('product.price'),
      dataIndex: 'salePrice',
      width: 120,
      align: 'center',
    },
    {
      title: $t('enterprise.price'),
      dataIndex: 'enterprisePrice',
      width: 120,
      align: 'center',
      render: (_, record) => (
        <Space>
          <span key="1">{_}</span>
          <span
            key="2"
            className={style.columnBtnEdit}
            onClick={() => {
              setEditItem(record);
              setVisiblePrice(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('inventory'),
      dataIndex: 'stock',
      width: 120,
      align: 'center',
      render(v, record) {
        const arr = record.supplierProductItemList;
        if (arr && arr.length) {
          return arr[0].stock;
        }
        if (![null, undefined].includes(v)) {
          return v;
        }
        return '-';
      },
    },
    {
      title: $t('available.date'),
      dataIndex: 'saleDate',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length ? (
            <div key="1">
              {_.length === 7 ? (
                $t('no.restriction')
              ) : (
                <span key="3">{_.map(item => weekOptions[item]).join('/')}</span>
              )}
            </div>
          ) : (
            <span key="2">-</span>
          )}
          <span
            key="4"
            className={style.columnBtnEdit}
            onClick={() => {
              setEditItem(record);
              setVisibleSaleDate(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('available.meal.period'),
      dataIndex: 'tabCate',
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length ? (
            <span key="1">
              {_.sort((x, y) => x - y)
                .map(item => mealColumn[item])
                .join('/')}
            </span>
          ) : (
            <span key="2" className={style.columnTip}>{$t('please.configure')}</span>
          )}
          <span
            key="3"
            className={style.columnBtnEdit}
            onClick={() => {
              setEditItem(record);
              setVisibleSaleSection(true);
            }}
          >
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: $t('food.type'),
      dataIndex: 'mealTypeList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: $t('actions'),
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r, i) => (
        <Button key="del" onClick={() => onDel(i)}>{$t('delete')}</Button>
      ),
    },
  ];
};

// 选择商品弹窗字段
export const SelectGoodsColumn = [
  {
    title: $t('product.id'),
    width: 120,
    align: 'center',
    dataIndex: 'skuId',
  },
  {
    title: $t('product.name'),
    dataIndex: 'skuName',
  },
  // {
  //   title: '商品编号',
  //   dataIndex: 'skuNo',
  //   width: 120,
  //   align: 'center',
  // },
  {
    title: $t('selling.price'),
    dataIndex: 'salePrice',
    width: 120,
    align: 'center',
  },
  {
    title: $t('remaining.stock'),
    dataIndex: 'stock',
    width: 100,
    align: 'center',
    render(v, record) {
      const arr = record.supplierProductItemList;
      if (arr && arr.length) {
        return arr[0].stock;
      }
      return '-';
    },
  },
  // {
  //   title: '已参与活动',
  //   dataIndex: 'activity',
  //   align: 'center',
  //   width: 110,
  //   hideInSearch: true,
  // },
];

// 企业虚拟商品列表字段
export const virtualGoodsColumn = options => {
  const { onDel, enterprises, enterpriseId, onChangeEnterprise } = options;
  return [
    {
      title: $t('enterprise.name'),
      dataIndex: 'enterpriseId',
      hideInTable: true,
      valueType: 'select',
      fieldProps: {
        value: enterpriseId ? +enterpriseId : null,
        showSearch: true,
        filterOption: (v, option) => (option?.label ?? '').toLowerCase().includes(v.toLowerCase()),
        onChange: onChangeEnterprise,
        options: enterprises,
        allowClear: false,
      },
    },
    {
      title: $t('westore.name'),
      dataIndex: 'shopId',
      hideInTable: true,
      fieldProps: {
        showSearch: true,
        filterOption: false,
        // onSearch: getShopList,
      },
      request: getShopList,
      valueEnum: {}, // shopEnum,
    },
    {
      title: $t('westore.name'),
      dataIndex: 'shopName',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('sku.code'),
      dataIndex: 'skuId',
      width: 160,
      align: 'center',
    },
    {
      title: $t('product.name'),
      dataIndex: 'skuName',
      align: 'center',
    },
    {
      title: $t('product.image'),
      dataIndex: 'primaryImage',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueType: 'image',
    },
    {
      title: $t('available.date'),
      dataIndex: 'saleDateList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length && (
            <div>
              {_.length === 7 ? $t('no.restriction') : <span>{_.map(item => item.name).join('/')}</span>}
            </div>
          )}
        </Space>
      ),
    },
    {
      title: $t('available.meal.period'),
      dataIndex: 'tabCateList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          {_ && _.length && (
            <span>
              {_.sort((x, y) => x.tabId - y.tabId)
                .map(item => item.tabName)
                .join('/')}
            </span>
          )}
        </Space>
      ),
    },
    {
      title: $t('enterprise.price'),
      dataIndex: 'activityPrice',
      width: 100,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
        </Space>
      ),
    },
    {
      title: $t('product.sales.price'),
      dataIndex: 'price',
      width: 100,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      width: 80,
      align: 'center',
      hideInSearch: true,
      valueEnum: {
        1: $t('listed'),
        2: $t('delisted'),
        3: $t('sold.out'),
      },
    },
    {
      title: $t('food.type'),
      dataIndex: 'mealTypeList',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(arr) {
        if (arr && arr.length) {
          return arr.map(item => item.name).join('/');
        }
        return '-';
      },
    },
    {
      title: $t('add.time'),
      dataIndex: 'createDate',
      width: 120,
      valueType: 'dateRange',
      align: 'center',
      render(v, record) {
        return record.createDate;
      },
    },
    {
      title: $t('available.meal.period'),
      dataIndex: 'tabId',
      align: 'center',
      valueEnum: mealColumn,
      hideInTable: true,
    },
    {
      title: $t('actions'),
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r.id)}>{$t('delete')}</Button>
      ),
    },
  ];
};
