import React, { useEffect } from 'react';
import { Form, InputNumber, Modal, notification } from 'antd';
import { isCheckPriceTwoDecimal } from '@/utils/validator';
import { apiMealInfoUpdate } from '../service';

const SaleDateModal = props => {
  const [form] = Form.useForm();

  const layout = {
    labelCol: { span: 8 },
    wrapperCol: { span: 14 },
  };

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    if (props.id) {
      const params = {
        id: props.id,
        enterprisePrice: res.price,
      };
      await apiMealInfoUpdate(params);
      notification.success({ message: $t('saved.successfully') });
    }
    handleCancel();
    props.handleRefresh(res.price);
  };

  useEffect(() => {
    if (props.visible) {
      const price = props.item?.enterprisePrice || props.item?.activityPrice || null;
      form.setFieldsValue({ price });
    }
  }, [props.visible]);

  return (
    <Modal
      title={$t('edit.enterprise.product.price')}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="400px"
      okText={$t('save')}
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basicInfo" {...layout} form={form}>
        <Form.Item
          label={$t('enterprise.product.price')}
          name="price"
          rules={[
            { required: true, message: $t('enter.product.price') },
            { validator: isCheckPriceTwoDecimal, message: $t('enter.valid.price') },
          ]}
        >
          <InputNumber addonAfter={$t('cny')} max={99999.99} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SaleDateModal;
