import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { customerColumn } from './staticData/index';
import CustomerInfo from './components/CustomerInfo';
import utilStyle from '@/utils/utils.less';
import { stringOrObjectTrim } from '@/utils/utils';
import { apiEnterpriseList } from './service';

const BusinessCustomer = () => {
  const refTable = useRef();
  const [visible, setVisible] = useState(false);
  const [id, setId] = useState('');
  const query = async params => {
    const data = {
      page: params.current,
      size: params.pageSize,
      data: stringOrObjectTrim(params),
    };
    const res = await apiEnterpriseList(data);
    return {
      data: res.data.records,
      total: res.data.total,
    };
  };
  const onEdit = v => {
    setId(v);
    setVisible(true);
  };

  return (
    <div className={utilStyle.formPageBox}>
      <ProTable
        actionRef={refTable}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={customerColumn({ onEdit })}
        request={params => query({ ...params })}
        rowKey={r => r.id}
        expandIconColumnIndex={10}
        bordered
        options={false}
        toolBarRender={() => [
          <Button
            key="3"
            icon={<PlusOutlined />}
            type="primary"
            onClick={() => {
              setId('');
              setVisible(!0);
            }}
          >{$t('add.corporate.client')}</Button>,
        ]}
      />
      <CustomerInfo
        visible={visible}
        id={id}
        reFresh={() => refTable.current.reload()}
        handleClose={setVisible}
      />
    </div>
  );
};

export default BusinessCustomer;
