import React from 'react';
import { Form, InputNumber, Row, Col } from 'antd';
import style from '../style/info.less';
import { validateRequired, isCheckPriceTwoDecimal } from '@/utils/validator';

const MealLimit = props => (
  <Form.Item
    label={`${props.label}${$t('quota')}`}
    name={props.name}
    rules={[
      { validator: validateRequired, message: `${$t('please.enter')}${props.label}${$t('quota')}` },
      { validator: isCheckPriceTwoDecimal, message: $t('enter.valid.price') },
    ]}
  >
    <InputNumber addonAfter={$t('cny')} max={999.99} />
  </Form.Item>
);

export default MealLimit;
