import React from 'react';
import { Image as ImageComponent, Button } from 'antd';
import { FormOutlined } from '@ant-design/icons';

export const repastTypeList = [
  {
    value: 1,
    label: $t('takeaway'),
  },
  {
    value: 2,
    label: $t('buffet'),
  },
  {
    value: 4,
    label: $t('instore'),
  },
];

const repastType = list => {
  if (list.includes(4) && list.length > 1) {
    return list
      .filter(item => item !== 4)
      .map(item => {
        const name = repastTypeList.find(i => i.value === item)?.label;
        return name ? `${name}${$t('instore')}` : null;
      });
  }
  return list.map(item => {
    const name = repastTypeList.find(i => i.value === item)?.label;
    return name ? `${name} ` : null;
  });
};
export const columns = props => [
  {
    title: $t('westore.id'),
    key: 'shopId',
    dataIndex: 'shopId',
    align: 'center',
  },
  {
    title: $t('westore.name'),
    key: 'shopName',
    dataIndex: 'shopName',
    align: 'center',
  },
  {
    title: $t('food.type'),
    key: 'mealType',
    dataIndex: 'mealType',
    align: 'center',
    render: (_, row) => {
      const status = !row?.pickNameList?.length;
      const isArray = Array.isArray(row?.mealType);
      if (isArray) {
        return (
          <Button type="text" disabled={status} onClick={() => props.editRepastType(row)}>
            {repastType(row?.mealType)}
            <FormOutlined />
          </Button>
        );
      }
      return '/';
    },
  },
  {
    title: $t('company.pickup.point'),
    key: 'pickNameList',
    dataIndex: 'pickNameList',
    align: 'center',
    render: (text, record) => {
      if (record.pickNameList?.length) {
        return text.map((item, index) => (
          <span key={item}>
            {item}
            {index < record.pickNameList.length - 1 && ','}
          </span>
        ));
      }
      return '/';
    },
  },
  {
    title: $t('modified.by'),
    key: 'updatedBy',
    dataIndex: 'updatedBy',
    align: 'center',
  },
  {
    title: $t('edit.time'),
    key: 'updatedAt',
    dataIndex: 'updatedAt',
    align: 'center',
  },
  {
    title: $t('actions'),
    dataIndex: 'option',
    valueType: 'option',
    align: 'center',
    key: 'option',
    render: (_, row) => (
      <Button type="link" disabled={row?.pickNameList?.length} onClick={() => props.delShop(row)}>{$t('delete')}</Button>
    ),
  },
];
