import React from 'react';
import { Button } from 'antd';

export const dateStateEnum = {
  1: { text: $t('weekly.settlement'), maxlength: 8 },
  2: { text: $t('halfmonth.settlement'), maxlength: 4 },
  3: { text: $t('monthly.settlement'), maxlength: 2 },
  4: { text: $t('daily.settlement'), maxlength: 20 },
  5: { text: $t('halfday.settlement'), maxlength: 20 },
};

export const orderStateNum = {
  1: { text: $t('pending.settlement') },
  2: { text: $t('settled') },
  3: { text: $t('no.settlement.needed') },
};

export const paymentStateEnum = {
  true: { text: $t('yes') },
  false: { text: $t('no') },
};

export function columns(pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: $t('serial.no'),
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      align: 'center',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: $t('supplier.name'),
      dataIndex: 'supplierName',
      width: '150px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('payment.batch.id'),
      dataIndex: 'payBatchNo',
      width: '160px',
      align: 'center',
    },
    {
      title: $t('settlement.batch.no'),
      dataIndex: 'settleBatchNo',
      width: '150px',
      align: 'center',
    },
    {
      title: $t('settlement.date'),
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: $t('billing.cycle'),
      dataIndex: 'createdAtRange',
      key: 'createdAtRange',
      hideInSearch: true,
      align: 'center',
      width: '160px',
      render: (text, record) => `${record.billPeriodStart}-${record.billPeriodEnd}`,
    },
    {
      title: $t('billing.cycle'),
      dataIndex: 'billPeriodType',
      valueEnum: dateStateEnum,
      width: '120px',
      hideInSearch: true,
      filters: false,
      align: 'center',
    },
    {
      title: $t('settlement.date'),
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: $t('sales.amount'),
      dataIndex: 'saleAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('refund.amount'),
      dataIndex: 'refundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => (
        <div>
          <div>{value}</div>
          <div style={{ color: '#f00' }}>{$t('compensation')}{row.claimAmount})</div>
        </div>
      ),
    },
    {
      title: $t('settlement.amount'),
      dataIndex: 'payableAmount',
      width: '130px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('settlement.status'),
      dataIndex: 'settleState',
      valueEnum: orderStateNum,
      width: '100px',
      initialValue: 0,
      filters: false,
      align: 'center',
    },
    {
      title: $t('generate.payment.order'),
      dataIndex: 'isCreatePaymentBill',
      valueEnum: paymentStateEnum,
      hideInTable: true,
      align: 'center',
    },
  ];
}

export const toolBarRender = ({ paymentOrder, canEditable }) => () => [
  canEditable ? (
    <Button type="primary" onClick={paymentOrder}>{$t('generate.payment')}</Button>
  ) : (
    <></>
  ),
];
