import { Button } from 'antd';
import React from 'react';

export const activeStateEnum = {
  10: { text: $t('sales') },
  20: { text: $t('aftersales') },
};

export const orderStateNum = {
  1: { text: $t('pending.confirmation') },
  2: { text: $t('confirmed') },
  3: { text: $t('settlement.generated') },
};

export function columns(pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: $t('serial.no'),
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      align: 'center',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: $t('supplier.name'),
      dataIndex: 'supplierName',
      width: '150px',
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('settlement.batch.no'),
      dataIndex: 'settleBatchNo',
      width: '160px',
      align: 'center',
    },
    {
      title: $t('bill.date'),
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: $t('bill.date'),
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: $t('bill.type'),
      dataIndex: 'billType',
      valueEnum: activeStateEnum,
      width: '120px',
      filters: false,
      align: 'center',
    },
    {
      title: $t('amount'),
      dataIndex: 'amount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => {
        const msg = row.billType === 20 ? <div>{$t('include.compensation.amount')}</div> : null;
        return (
          <div>
            <div>{value}</div>
            {msg}
          </div>
        );
      },
    },
    {
      title: $t('transaction.count'),
      dataIndex: 'quantity',
      width: '100px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => {
        const msg = row.billType === 20 ? <div>{$t('include.compensation.count')}</div> : null;
        return (
          <div>
            <div>{value}</div>
            {msg}
          </div>
        );
      },
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      valueEnum: orderStateNum,
      width: '100px',
      filters: false,
      align: 'center',
    },
  ];
}

export const toolBarRender = gather => {
  const { onDownload, confirmAction, canEditable } = gather;
  return () => [
    <Button type="primary" style={{ marginRight: '20px' }} onClick={onDownload}>{$t('download')}</Button>,
    canEditable ? (
      <Button type="primary" onClick={confirmAction}>{$t('confirm')}</Button>
    ) : (
      ''
    ),
  ];
};
