import React, { useState, useEffect } from 'react';
import { Modal, Button } from 'antd';
import { apiQueryLastAuditRecord } from '../service';

const InfoAudit = props => {
  const [audit, setAudit] = useState({});

  const getRecord = async () => {
    const res = await apiQueryLastAuditRecord(props.skuInfo.skuId);
    if (res && res.data) {
      console.log('res :>> ', res);
      setAudit(res.data);
    }
  };

  const getContent = () => {
    const obj = {
      1: '-',
      2: $t('review.passed'),
      3: `${$t('rejected')}${audit.rejectReason}`,
    };
    if (audit) {
      return obj[audit.status] || '';
    }
    return '';
  };

  useEffect(() => {
    if (props.visible) {
      getRecord();
    }
  }, [props.visible]);

  return (
    <Modal
      title={$t('product.change.review')}
      visible={props.visible}
      closable={false}
      footer={[
        audit.status === 3 &&
          props.canEditable &&
          (props.skuInfo.state === 4 ||
            (props.skuInfo.state >= 5 && props.skuInfo.updateState !== 1)) && (
            <Button key="back" type="primary" onClick={() => props.onEdit()}>{$t('edit.again')}</Button>
          ),
        <Button key="close" onClick={() => props.onCancel()}>{$t('close')}</Button>,
      ]}
    >
      <p>{$t('review.status')}{audit.statusDesc}</p>
      <p>{$t('apply.time')}{audit.createdAt}</p>
      <p>{$t('review.result')}{getContent()}</p>
    </Modal>
  );
};

export default InfoAudit;
