import React from 'react';
import { Modal, Form, Radio } from 'antd';

const SendModal = options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
    options.confirm({
      type: 6,
      ...values,
    });
  };

  const radioOptions = [{ label: $t('singleitem.deliverable'), value: 1 }, { label: $t('singleitem.not.deliverable'), value: 0 }];
  const initialValues = Object.assign({}, options.initialValues);

  return (
    <Modal
      visible={options.visible}
      title={$t('set.as.nondeliverable')}
      onOk={handleOk}
      maskClosable={false}
      keyboard={false}
      confirmLoading={options.loading}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label={$t('singleitem.delivery')}
          name="isSingleDelivery"
          rules={[{ required: true, message: $t('selection.required') }]}
        >
          <Radio.Group options={radioOptions} />
        </Form.Item>
      </Form>
      <div>{$t('selected.items.cannot.be.ordered.alone')}</div>
    </Modal>
  );
};

export default SendModal;
