import {
  Form,
  Button,
  Input,
  Select,
  notification,
  Upload,
  Tag,
  Cascader,
  InputNumber,
  Popover,
  Divider,
} from 'antd';
import React, { Component, useState } from 'react';
import { SwapRightOutlined } from '@ant-design/icons';
import { connect } from 'dva';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import styles from '../style.less';
import { stateList } from '../staticdata';
import { apiGoodsInfosExport } from '../service';
import { GOOD_MANAGE } from '@/../config/permission.config';

const FormItem = Form.Item;
const { Option } = Select;
@connect(({ goodsManage, menu }) => ({
  goodsManage,
  permissions: menu.permissions,
}))
class goodsManage extends Component {
  formRef = React.createRef();

  state = {
    loading: false,
    productType: null,
  };

  componentDidMount() {
    this.props.onRef(this);
    this.handleSearch();
  }

  getFieldsValue() {
    const form = this.formRef.current;
    return form.getFieldsValue();
  }

  handleSearch = () => {
    this.props.handleSearch(1);
  };

  valueMin = value => {
    const { getFieldValue, setFieldsValue } = this.formRef.current;
    const minVal = getFieldValue('supplyPriceMin');
    if (minVal && minVal > value) {
      setFieldsValue({ supplyPriceMax: minVal });
    }
  };

  onReset = () => {
    const form = this.formRef.current;
    form.resetFields();
    this.props.onReset();
    this.props.changeProductType(1);
    this.setState({
      productType: 1,
    });
  };

  addSpu = () => {
    this.props.addSpu();
  };

  setArea = (isAll, type) => {
    this.props.setArea(isAll, type);
  };

  // 验证是否可以修改库存
  checkEnableUpdateStock = () => {
    if (this.props.selectNum) {
      this.props.checkStock();
    } else {
      notification.info({ message: $t('select') });
    }
  };

  onChangeProductType = (v = null) => {
    const form = this.formRef.current;
    form.setFieldsValue({
      skuId: '',
      skuName: '',
      thirdSkuNo: '',
      productCategoryId: null,
      state: null,
      supplyPriceMin: null,
      supplyPriceMax: null,
      productType: v,
    });
    this.props.changeProductType(v);
    this.setState({
      productType: v,
    });
  };

  // 导出明细
  onExportGoodsInfo = async () => {
    this.setState({
      loading: true,
    });
    const form = this.formRef?.current?.getFieldValue();
    const params = Object.assign({}, form);
    const productCategoryId = form?.productCategoryId || [];
    if (productCategoryId.length) {
      params.productCategoryId = productCategoryId[productCategoryId.length - 1] || '';
    }
    const res = await apiGoodsInfosExport(params);
    this.setState({
      loading: false,
    });
    if (res) {
      const blob = new Blob([res]);
      saveAs(blob, `${$t('product.details')}${format(new Date(), 'yyyyMMdd')}.xlsx`);
    } else {
      notification.error({ message: $t('download.failed') });
    }
  };

  render() {
    const { treeData, permissions } = this.props;
    const selectW = { width: 250 };
    const iptNumWidth = { width: 118 };
    const canEditable = permissions[GOOD_MANAGE.EDITABLE];
    const content = (
      <div>
        <Button style={{ border: 'none' }} onClick={() => this.setArea(1, 'distribution')}>{$t('global.shipping.zones')}</Button>
        <br />
        <Button style={{ border: 'none' }} onClick={() => this.setArea(0, 'distribution')}>{$t('selected.shipping.zones')}</Button>
        <br />
        <Button style={{ border: 'none' }} onClick={() => this.setArea(1, 'after')}>{$t('global.aftersales.address')}</Button>
        <br />
        <Button style={{ border: 'none' }} onClick={() => this.setArea(0, 'after')}>{$t('selected.product.address')}</Button>
        <br />
        <Button style={{ border: 'none' }} onClick={() => this.checkEnableUpdateStock()}>{$t('selected.product.inventory')}</Button>
      </div>
    );

    const filterOption = (input, op) => op.props.children.includes(input);
    return (
      <Form
        ref={this.formRef}
        name="horizontal_login"
        initialValues={{ productType: 1 }}
        layout="inline"
        className={styles.searchForm}
      >
        <FormItem label={$t('sku.code')} name="skuId">
          <InputNumber placeholder={$t('enter.sku.code')} max={99999999999999999} style={selectW} />
        </FormItem>
        <FormItem label={$t('product.name')} name="skuName">
          <Input placeholder={$t('enter.product.name')} allowClear style={selectW} />
        </FormItem>
        <FormItem label={$t('product.type')} name="productType">
          <Select style={selectW} placeholder={$t('select.product.type')} onChange={this.onChangeProductType}>
            <Option value={1}>{$t('physical.goods')}</Option>
            <Option value={4}>{$t('service.products')}</Option>
            <Option value={5}>{$t('delivery.products')}</Option>
          </Select>
        </FormItem>
        <FormItem label={$t('category')} name="productCategoryId">
          <Cascader
            placeholder={$t('select.category')}
            style={selectW}
            showSearch
            changeOnSelect
            fieldNames={{ label: 'name', value: 'id', children: 'children' }}
            options={treeData}
          />
        </FormItem>
        {this.state.productType !== 5 && (
          <>
            <FormItem label={$t('review.status')} name="state">
              <Select
                style={selectW}
                placeholder={$t('select.audit.status')}
                allowClear
                filterOption={filterOption}
              >
                {stateList?.map(item => (
                  <Option key={item.value} value={item.value}>
                    {item.label}
                  </Option>
                ))}
              </Select>
            </FormItem>
            {/* <FormItem label="供货价区间">
              <FormItem name="supplyPriceMin" className={styles.iptNumRight} noStyle>
                <InputNumber placeholder="请输入" min={0} max={999999999} style={iptNumWidth} />
              </FormItem>
              <span>
                <SwapRightOutlined />
              </span>
              <FormItem name="supplyPriceMax" className={styles.iptNumRight} noStyle>
                <InputNumber
                  style={iptNumWidth}
                  min={0}
                  max={999999999}
                  placeholder="请输入"
                  onChange={this.valueMin}
                />
              </FormItem>
            </FormItem> */}
            <FormItem name="thirdSkuNo" label={$t('thirdparty.sku')}>
              <Input placeholder={$t('enter.thirdparty.sku')} allowClear style={selectW} />
            </FormItem>
          </>
        )}
        <FormItem className={styles.queryBtn}>
          <Button onClick={() => this.handleSearch()} type="primary" className={styles.button}>{$t('query')}</Button>
          <Button onClick={() => this.onReset()} className={styles.button}>{$t('reset')}</Button>
          {this.state.productType !== 5 && (
            <>
              <Button
                loading={this.state.loading}
                onClick={() => this.onExportGoodsInfo()}
                type="primary"
                ghost
                className={styles.button}
              >{$t('export')}</Button>
              {/* {canEditable ? (
                <FormItem style={{ float: 'right' }}>
                  <Popover content={content} onVisibleChange={this.handleVisibleChange}>
                    <Button type="primary" className={styles.button}>
                      批量设置
                    </Button>
                  </Popover>
                  {this.props.selectNum > 0 && (
                    <Tag color="green">已选商品 {this.props.selectNum}</Tag>
                  )}
                </FormItem>
              ) : (
                ''
              )} */}
            </>
          )}
        </FormItem>
      </Form>
    );
  }
}

export default goodsManage;
