import React, { useState, useRef } from 'react';
import { Modal, notification, Form } from 'antd';
import Upload from './CustomUpload';
import { formItemLayout } from '../data';
import { apiUploadSupplementaryBill } from '../service';

/**
 * 上传发票弹窗
 * */
const UploadInvoiceModal = props => {
  const { id } = props;
  const refForm = useRef();

  const onConfirm = async () => {
    const res = await refForm.current?.validateFields?.();
    if (res?.fileList?.length) {
      const { fileList } = res;
      const params = {
        filePath: fileList[0].url,
        fileName: fileList[0]?.name || '',
        id,
      };
      const data = await apiUploadSupplementaryBill(params);
      if (data.businessCode === '0000') {
        notification.success({ message: $t('upload.successful') });
        props.onCancel(true);
      }
    }
  };

  return (
    <Modal width={500} title={$t('supplement.invoice')} open onOk={onConfirm} onCancel={props.onCancel}>
      <Form ref={refForm} {...formItemLayout}>
        <Form.Item
          label={$t('upload.invoice')}
          name="fileList"
          rules={[{ required: true }]}
          extra={$t('supported.pdfdocdocxpngjpegjpgziprar')}
        >
          <Upload limit={1} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default UploadInvoiceModal;
