import React, { useEffect } from 'react';
import { layout } from '@/utils/bll';
import { BetaSchemaForm } from '@ant-design/pro-components';
import { paymentInfoColumn } from '../data';

const PaymentBill = props => {
  const refForm = React.useRef();

  const closeModal = v => {
    !v && props.onClose(false);
  };

  const onSubmit = async v => {
    // 关闭
    closeModal();
  };

  const getInfo = async () => {
    const info = props.info || {};
    let images = []; // info.paySuccessImage;
    if (info.paySuccessImages?.length) {
      images = info.paySuccessImages.map((item, i) => ({
        url: item,
        uid: i,
        status: 'done',
        name: '',
      }));
    }
    const params = {
      images,
      comment: info.payComment || '',
    };
    refForm.current?.setFieldsValue?.(params);
    const res = refForm.current?.getFieldsValue();
    console.log(res);
  };
  useEffect(() => {
    if (props.visible) {
      getInfo();
    }
  }, [props.visible]);

  return (
    props.visible && (
      <BetaSchemaForm
        layoutType="ModalForm"
        title={$t('view.payment.bill')}
        open={props.visible}
        width="600px"
        modalProps={{
          maskClosable: false,
          destroyOnClose: true,
          okText: () => <></>,
          cancelText: $t('close'),
        }}
        formRef={refForm}
        onOpenChange={closeModal}
        layout="horizontal"
        {...layout}
        onFinish={onSubmit}
        columns={paymentInfoColumn(props.status)}
      />
    )
  );
};

export default PaymentBill;
