import React from 'react';
import { Button, Dropdown, Menu, message, Modal } from 'antd';
import { PlusOutlined, DownOutlined, ExclamationCircleOutlined } from '@ant-design/icons';
import { batchAction } from '../../staticdata';
import styles from '../../style.less';
import { apiGoodsActionBatch } from '../../service';

const ActionBar = options => {
  // 上下架
  const changeStatus = async state => {
    console.log('options.shopId :>> ', options.shopId);
    Modal.confirm({
      icon: <ExclamationCircleOutlined />,
      content: `${$t('confirm')}${+state === 6 ? '下架' : '上架'}${$t('product')}`,
      onOk: async () => {
        const res = await apiGoodsActionBatch({
          skuIds: options.selectedRowKeys,
          type: 2,
          shopId: options.shopId,
          productStatus: +state === 6 ? 0 : 1, // 6：上架，7:下架
        });
        if (res.businessCode === '0000' && res.code === '0000') {
          options.handleSearch();
          message.success($t('processed.successfully'));
        }
      },
    });
  };

  /**
   * 批量操作
   * up     上架
   * down   下架
   * stock  修改库存
   * time   修改可售时间
   * group  修改分组
   * send   设置单点不送
   * buy    修改最少购买数量
   */
  const onChangeState = type => {
    if (options.selectedRowKeys && options.selectedRowKeys.length) {
      if (['up', 'down'].includes(type)) {
        changeStatus(type === 'up' ? 7 : 6);
      } else {
        options.openModal(type);
      }
    } else {
      message.warning($t('product.selection.required'));
    }
  };

  const eventObj = {
    onChangeState,
  };
  const actions = batchAction(eventObj);

  const menus = (
    <Menu>
      {actions.map(item => (
        <Menu.Item key={item.key}>{item.label}</Menu.Item>
      ))}
    </Menu>
  );

  return (
    <div className={styles['action-bar-box']}>
      {(options.canAddTakeaway && (
        <Button type="primary" icon={<PlusOutlined />} onClick={options.newGoods}>{$t('add.products.under.category')}</Button>
      )) ||
        ''}
      <Dropdown overlay={menus} className={styles['action-bar-box--down']} placement="bottomLeft">
        <Button type="primary">{$t('batch.actions')}<DownOutlined />
        </Button>
      </Dropdown>
    </div>
  );
};

export default ActionBar;
