import React from 'react';
import { Modal, Form, Input, Checkbox, message } from 'antd';
import styles from '../index.less';
import { apiStaffBlack } from '../service';

const { Item } = Form;

const BlacklistModal = ({ visible, onClose, list, enterpriseId, selectedRows }) => {
  const [form] = Form.useForm();

  const handleSave = async () => {
    const values = await form.validateFields();
    const params = {
      enterpriseId,
      ids: list,
      isBlack: 1,
      balanceBackFlag: 1,
    };
    const res = await apiStaffBlack(params);
    if (res?.businessCode === '0000') {
      message.success($t('setup.success'));
      onClose(true, 'blacklist');
    }
  };

  return (
    <Modal
      visible={visible}
      title={$t('set.employee.blacklist')}
      onCancel={() => onClose(false, 'blacklist')}
      onOk={handleSave}
    >
      <Form form={form} layout="vertical">
        <Item name="ids" label={$t('confirm.employee.id')}>
          {(selectedRows.length &&
            selectedRows.map(item => <span key={item.staffNo}>{item.staffNo},</span>)) ||
            ''}
        </Item>
        <Item name="reason" label={$t('add.to.blacklist')}>
          <div className={styles.blackList}>
            <Checkbox defaultChecked disabled></Checkbox>
            <div className={styles.left}>
              <span>{$t('confirm.to.retrieve.employee.balance')}&餐券吗？ </span>
              <br />
              <span>{$t('check.to.retrieve.leave.unchecked.to.not.retrieve')}</span>
            </div>
          </div>
        </Item>
      </Form>
    </Modal>
  );
};

export default BlacklistModal;
