import React from 'react';
import { Image as ImageComponent, Button } from 'antd';

export const getLastItem = thePath => thePath.substring(thePath.lastIndexOf('/') + 1);
export const isImageType = url => {
  const index = url.lastIndexOf('.');
  const ext = url.substr(index + 1);
  return ['png', 'jpg', 'jpeg', 'bmp', 'gif', 'webp', 'psd', 'svg', 'tiff'].includes(
    ext.toLowerCase(),
  );
};

export const checkImage = url =>
  new Promise(resolve => {
    const image = new Image();
    image.onload = () => {
      resolve(true);
    };
    image.onerror = () => {
      resolve(false);
    };
    image.src = url;
  });

const csListStyle = {
  color: '#1890FF',
  textAlign: 'left',
  whiteSpace: 'nowrap',
  textOverflow: 'ellipsis',
  overflow: 'hidden',
  cursor: 'pointer',
};

export const typeConfig = {
  1: {
    text: $t('shipping.refund'),
  },
  2: {
    text: $t('product.damaged'),
  },
};

const singleNumberSearch = {
  0: {
    text: $t('claim.number'),
  },
  1: {
    text: $t('order.no'),
  },
};

export const columnsConfig = props => [
  {
    title: $t('search.by.id'),
    key: 'singleType',
    dataIndex: 'singleType',
    hideInTable: true,
    valueEnum: singleNumberSearch,
  },
  {
    key: 'singleNumber',
    dataIndex: 'singleNumber',
    hideInTable: true,
  },
  {
    title: $t('claim.number'),
    key: 'id',
    dataIndex: 'id',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: $t('order.no'),
    key: 'orderNo',
    dataIndex: 'orderNo',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: $t('claim.amount'),
    key: 'amount',
    dataIndex: 'amount',
    align: 'center',
    width: 100,
    hideInSearch: true,
  },
  {
    title: $t('claim.type'),
    key: 'type',
    dataIndex: 'type',
    align: 'center',
    valueEnum: typeConfig,
  },
  {
    title: $t('claim.reason'),
    key: 'reason',
    dataIndex: 'reason',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: $t('refund.note'),
    key: 'remark',
    dataIndex: 'remark',
    align: 'center',
    ellipsis: true,
    hideInSearch: true,
  },
  {
    title: $t('creation.time'),
    key: 'createdAt',
    dataIndex: 'createdAt',
    align: 'center',
    valueType: 'dateRange',
  },
  {
    title: $t('user.credential'),
    key: 'proof',
    dataIndex: 'proof',
    align: 'center',
    width: 190,
    hideInSearch: true,
    render: value =>
      (value.userList || []).map(item => (
        <ImageComponent style={{ paddingLeft: 5, marginTop: 5 }} key={item} width={50} src={item} />
      )),
  },
  {
    title: $t('review.comments'),
    key: 'proof',
    dataIndex: 'proof',
    align: 'center',
    width: 190,
    hideInSearch: true,
    render: value =>
      (value.csList || []).map(item => (
        <div style={csListStyle} onClick={() => props.downLoadFile(item)}>
          {item}
        </div>
      )),
  },
];
