import React, { useState, useEffect } from 'react';
import { Row, Col } from 'antd';
import { Link } from 'umi';
import { FileTextOutlined } from '@ant-design/icons';
import style from './styles.less';
import { getPendingNum } from './service';
import { connect } from 'dva';
import { AFTER_SALE_ORDER, PENDING_DELIVERY_ORDER } from '@/../config/permission.config';

const Admin = props => {
  const [pendingNum, setPendingNum] = useState({});
  const showAfterSaleList = props.permissions[AFTER_SALE_ORDER.LIST];
  const showPendingDeliveryOrderList = props.permissions[PENDING_DELIVERY_ORDER.LIST];

  const query = async () => {
    const res = await getPendingNum();
    setPendingNum(res?.data || {});
  };

  useEffect(() => {
    query();
  }, []);

  return (
    <div>
      <h2>{$t('welcome.to.merchant.system')}</h2>
      <div>
        <div>
          <span className={style.orderleft}></span>
          <span className={style.orderRight}>{$t('pending')}</span>
        </div>
        <div style={{ marginTop: '20px' }}>
          <Row className={style.orderContent}>
            {showPendingDeliveryOrderList || showAfterSaleList ? (
              <Col span={2} className="titleOne">
                <div>
                  <FileTextOutlined />
                  <p>{$t('order')}</p>
                </div>
              </Col>
            ) : (
              ''
            )}

            {showPendingDeliveryOrderList ? (
              <>
                <Col span={2}>
                  <Link
                    to={{
                      pathname: '/orderManage/pendingDeliveryOrder',
                    }}
                  >
                    <strong>{pendingNum?.pendingShipNum || 0}</strong>
                    <p>{$t('pending.shipment')}</p>
                  </Link>
                </Col>
                <Col span={3}>
                  <Link
                    to={{
                      pathname: '/orderManage/pendingDeliveryOrder',
                      state: { status: 1 },
                    }}
                  >
                    <strong>{pendingNum?.timeOutShipNum || 0}</strong>
                    <p>{$t('late.shipment')}{'>'}{$t('48.hours')}</p>
                  </Link>
                </Col>
              </>
            ) : (
              ''
            )}
            {showAfterSaleList ? (
              <Col span={4}>
                <Link
                  to={{
                    pathname: 'afterSaleManage',
                    query: {
                      tab: '1',
                    },
                  }}
                >
                  <strong>{pendingNum?.cancelOrderPendingAuditNum || 0}</strong>
                  <p>{$t('cancel.order.review')}{'<'}{$t('24.hours')}</p>
                </Link>
              </Col>
            ) : (
              ''
            )}
            {showAfterSaleList ? (
              <>
                <Col span={2} className="titleTwo" offset={4}>
                  <div>
                    <FileTextOutlined />
                    <p>{$t('aftersales')}</p>
                  </div>
                </Col>

                <Col span={3}>
                  <Link
                    to={{
                      pathname: 'afterSaleManage',
                    }}
                  >
                    <strong>{pendingNum?.afterOrderPendingAuditNum || 0}</strong>
                    <p>{$t('refund.pending')}{'<'}{$t('24.hours')}</p>
                  </Link>
                </Col>
                <Col span={4}>
                  <Link
                    to={{
                      pathname: 'afterSaleManage',
                    }}
                  >
                    <strong>{pendingNum?.interceptRefundPendingAuditNum || 0}</strong>
                    <p>{$t('pending.interception.review')}{'<'}{$t('48.hours')}</p>
                  </Link>
                </Col>
              </>
            ) : (
              ''
            )}
          </Row>
        </div>
      </div>
    </div>
  );
};
export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(Admin);
