import { DownloadOutlined } from '@ant-design/icons';
import { Popover, Typography } from 'antd';
import React, { useRef } from 'react';
import { connect } from 'dva';
import { isAntDesignPro } from '@/utils/utils';
import styles from './index.less';

const firstUpperCase = pathString =>
  pathString
    .replace('.', '')
    .split(/\/|-/)
    .map(s => s.toLowerCase().replace(/( |^)[a-z]/g, L => L.toUpperCase()))
    .filter(s => !!s)
    .join(''); // when  click block copy, send block url to  ga

const onBlockCopy = label => {
  if (!isAntDesignPro()) {
    return;
  }

  const ga = window && window.ga;

  if (ga) {
    ga('send', 'event', {
      eventCategory: 'block',
      eventAction: 'copy',
      eventLabel: label,
    });
  }
};

const BlockCodeView = ({ url }) => {
  const blockUrl = `npx umi block add ${firstUpperCase(url)} --path=${url}`;
  return (
    <div className={styles['copy-block-view']}>
      <Typography.Paragraph
        copyable={{
          text: blockUrl,
          onCopy: () => onBlockCopy(url),
        }}
        style={{
          display: 'flex',
        }}
      >
        <pre>
          <code className={styles['copy-block-code']}>{blockUrl}</code>
        </pre>
      </Typography.Paragraph>
    </div>
  );
};

export default connect(({ routing }) => ({
  location: routing.location,
}))(({ location }) => {
  const url = location.pathname;
  const divDom = useRef(null);
  return (
    <Popover
      title={$t('download.this.page.locally')}
      placement="topLeft"
      content={<BlockCodeView url={url} />}
      trigger="click"
      getPopupContainer={dom => (divDom.current ? divDom.current : dom)}
    >
      <div className={styles['copy-block']} ref={divDom}>
        <DownloadOutlined />
      </div>
    </Popover>
  );
});
