import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, notification } from 'antd';
import { shopCheck } from '../service';

const FormItem = Form.Item;
const { TextArea } = Input;
const RejectModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, validateFields, resetFields },
    serviceNo = null,
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const handleOk = () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const data = await shopCheck({
          ...fieldsValue,
          serviceNo,
          auditResult: 2,
        });
        if (data.code === '0000') {
          notification.success({ message: $t('operation.success') });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  return (
    <Modal title={$t('reject')} visible={visible} onOk={() => handleOk()} onCancel={() => handleCancel()}>
      <Form {...layout} name="formData">
        <FormItem label={$t('reason')}>
          {getFieldDecorator('refuseReasonRemark', {
            rules: [
              {
                required: true,
                message: $t('enter.reason'),
              },
            ],
          })(
            <TextArea placeholder={$t('enter.reason')} allowClear autoSize={{ minRows: 3, maxRows: 6 }} />,
          )}
        </FormItem>
      </Form>
    </Modal>
  );
};

export default Form.create()(RejectModal);
