import React, { useState, useEffect } from 'react';
import { Checkbox, Space, message, Modal, notification, Button } from 'antd';
import { weekOptions } from '../staticData/goods';
import { apiMealInfoUpdate, apiCheckInfo } from '../service';
import style from '../style/index.less';

const SaleDateModal = props => {
  const [value, setValue] = useState([]);
  const [loading, setLoading] = useState(false);
  const [checkAll, setCheckAll] = useState(false);

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeWeek = e => {
    setValue(e);
    setCheckAll(e?.length === 7);
  };

  // 提交
  const handleConfirm = async () => {
    if (!value || value.length < 1) {
      message.error($t('select.sale.dates'));
      return;
    }
    if (props.productType === 4) {
      const data = [];
      props.dataSource.forEach(item => {
        const obj = {
          saleDateList: item.saleDate,
          tabCateList: item.tabCate?.map(v => ({ tabId: v })),
        };
        if (props.item.skuId === item.skuId && item.tabCate) {
          obj.saleDateList = value;
          data.push(obj);
        } else if (item.saleDate?.length && item.tabCate?.length) {
          data.push(obj);
        }
      });
      setLoading(true);
      const res = await apiCheckInfo(data);
      setLoading(false);
      if (!res || !res.success) {
        return;
      }
    }
    if (props.id) {
      const params = {
        id: props.id,
        saleDateList: value,
      };
      setLoading(true);
      await apiMealInfoUpdate(params);
      setLoading(false);
      notification.success({ message: $t('saved.successfully') });
    }
    handleCancel();
    props.handleRefresh(value);
  };

  useEffect(() => {
    if (props.visible) {
      let v = [];
      let dateList = [];
      if (props.item) {
        if (props.type) {
          dateList = props.item[props.type];
        }
        dateList = dateList || props.item.saleDateList || props.item.saleDate;
      }
      if (dateList && dateList.length) {
        v = dateList.map(item => {
          if (typeof item === 'object') {
            return `${item.code}`;
          }
          return `${item}`;
        });
      }
      setCheckAll(v.length === 7);
      setValue(v);
    }
  }, [props.visible]);

  // 全选事件
  const onCheckAll = e => {
    if (e.target.checked) {
      setValue(Object.keys(weekOptions).map(w => `${w}`));
    } else {
      setValue([]);
    }
    setCheckAll(e.target.checked);
  };

  // 弹窗底部
  const footerComponent = [
    <div key="footer" className={style.modalFooters}>
      <Checkbox checked={checkAll} onChange={onCheckAll}>{$t('select.all')}</Checkbox>
      <div>
        <Button onClick={handleCancel}>{$t('cancel')}</Button>
        <Button type="primary" loading={loading} onClick={handleConfirm}>
          {' '}{$t('save')}{' '}
        </Button>
      </div>
    </div>,
  ];

  return (
    <Modal
      title={props.title || $t('set.sale.dates')}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="300px"
      footer={footerComponent}
    >
      <Checkbox.Group onChange={onChangeWeek} value={value}>
        <Space direction="vertical">
          {Object.keys(weekOptions).map(key => (
            <Checkbox key={key} value={key}>
              {weekOptions[key]}
            </Checkbox>
          ))}
        </Space>
      </Checkbox.Group>
    </Modal>
  );
};
export default SaleDateModal;
