import React from 'react';
import { Button } from 'antd';

export function renderModal() {
  return [
    <Button type="primary" key="cancel" onClick={() => this.handleCancel()}>{$t('cancel')}</Button>,
    <Button type="primary" onClick={() => this.handleSubmit()} key="save">{$t('submit')}</Button>,
  ];
}

export function detailsModal(filePath) {
  return [
    <Button type="primary" key="cancel" onClick={() => this.handleCancel()}>{$t('cancel')}</Button>,
    <Button type="primary" href={filePath} target="_blank" key="down">{$t('download')}</Button>,
  ];
}

export const formItemLayout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 18 },
};
