import React, { forwardRef, useImperativeHandle, useState, useRef, useEffect } from 'react';
import { Modal, Select, notification } from 'antd';
import { Form } from '@ant-design/compatible';
import { userEnabled, userDisabled, userDelete } from '@/pages/systemManage/service';

const FormComponent = props => {
  const { record = {}, form } = props;
  const { getFieldDecorator, setFieldsValue } = form;

  const formLayout = {
    labelCol: { span: 4 },
    wrapperCol: { span: 20 },
  };
  const formRules = {
    status: [{ required: true, message: '' }],
  };

  useEffect(() => {
    setFieldsValue(record);
  }, [record]);

  const rulesHandler = name => ({
    rules: formRules[name],
  });
  return (
    <Form {...formLayout}>
      <Form.Item label={$t('username')}>{record.name}</Form.Item>
      <Form.Item label={$t('status')}>
        {getFieldDecorator('status', rulesHandler('status'))(
          <Select>
            <Select.Option value={2}>{$t('in.use')}</Select.Option>
            <Select.Option value={3}>{$t('disabled')}</Select.Option>
            {record.currentStatus === 2 ? '' : <Select.Option value={1}>{$t('deleted')}</Select.Option>}
          </Select>,
        )}
      </Form.Item>
    </Form>
  );
};

const FormWarpper = Form.create({})(forwardRef(FormComponent));

const UpdateStatusModal = (props, ref) => {
  const { reload } = props;
  const formRef = useRef();
  const [visible, setVisible] = useState(false);
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [record, setRecord] = useState({
    name: '',
    status: '',
    id: '',
  });

  const open = item => {
    setVisible(true);
    const { name, status, id } = item;
    // 初始化数据,currentStatus 用来判断状态选项
    setRecord({
      name,
      status: status.value,
      id,
      currentStatus: status.value,
    });
  };

  const onCancel = () => {
    setVisible(false);
    setConfirmLoading(false);
    formRef.current.resetFields();
  };

  const onOk = () => {
    formRef.current.validateFields(async (err, fieldsValue) => {
      console.log('fieldsValue :>>', fieldsValue);
      if (err) {
        return;
      }

      const apiName = {
        1: userDelete,
        2: userEnabled,
        3: userDisabled,
      };
      const params = {
        id: record.id,
      };
      setConfirmLoading(true);
      const res = await apiName[fieldsValue.status](params);

      if (res.code !== 2000) {
        notification.warning({
          message: res.detail,
        });
        setConfirmLoading(false);
        return;
      }
      setConfirmLoading(false);
      notification.success({
        message: $t('saved.successfully'),
      });
      reload();
      onCancel();
    });
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: $t('edit.status'),
    visible,
    confirmLoading,
    onCancel,
    onOk,
  };

  return (
    <Modal {...modalProps}>
      <FormWarpper ref={formRef} record={record} />
    </Modal>
  );
};

export default forwardRef(UpdateStatusModal);
