import React, { useRef } from 'react';
import { useHistory } from 'react-router-dom';
import { Button, Divider } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';

// mock
import { logList } from '../mock/log';

const columns = [
  {
    title: $t('operator'),
    dataIndex: 'name',
  },
  {
    title: $t('primary.menu'),
    dataIndex: 'menu',
  },
  {
    title: $t('secondary.menu'),
    dataIndex: 'subMenu',
  },
  {
    title: $t('operation.point'),
    dataIndex: 'status',
    hideInSearch: true,
  },
  {
    title: $t('operation.time'),
    hideInSearch: true,
    dataIndex: 'actionTime',
  },
  {
    title: $t('operation.time.2'),
    hideInTable: true,
    dataIndex: 'actionTime1',
    valueType: 'dateRange',
  },
  {
    title: $t('actions'),
    key: 'action',
    hideInSearch: true,
    render: () => (
      <>
        <a>{$t('view')}</a>
      </>
    ),
  },
];

const SystemLog = props => {
  const history = useHistory();
  const actionRef = useRef();
  const formRef = useRef();

  const toUserInfo = (record = {}) => {
    const { id } = record;
    history.push({
      pathname: '/SystemManage/Account/UserInfo',
      query: {
        id: 1,
      },
    });
  };

  // 表格属性
  const tableProps = {
    columns,
    rowKey: 'id',
    request: params => {
      console.log($t('search'), params);
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            data: logList,
            success: true,
          });
        }, 2000);
      });
    },
    search: {
      collapsed: false,
      collapseRender: () => null,
    },
  };

  // 搜索属性
  const searchProps = {};
  return (
    <PageHeaderWrapper>
      <ProTable actionRef={actionRef} formRef={formRef} {...tableProps}></ProTable>
    </PageHeaderWrapper>
  );
};

export default SystemLog;
