import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import config from '../../../config/env.config';
// 查询
export async function query(params) {
  const tempParams = {
    ...params,
    startDate: params.dateRange?.[0],
    endDate: params.dateRange?.[1],
    pageNo: params.current,
  };
  delete tempParams.dateRange;
  delete tempParams.current;

  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/kdsp/account/account-verify-record-page', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(tempParams, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}
export async function supplier() {
  const { data } = await request.get('/api/merchants/suppliers/querylist', {
    prefix: config.kdspApi,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}

export async function downDetail(params) {
  const data = await request.get('/api/kdsp/account/account-verify-detail-downLoad', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: config.kdspApi,
    responseType: 'arrayBuffer',
  });
  const blob = new Blob([data]);
  saveAs(blob, `${$t('reconciliation.details')}${format(new Date(), 'yyyyMMddHHmmss')}.xlsx`);
}

export async function detailQuery(params) {
  const tempParams = {
    ...params,
    pageNo: params.current,
  };
  delete tempParams.current;

  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/kdsp/account/account-verify-detail-page', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(tempParams, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}

export async function updateStatus(params) {
  const { businessCode } = await request.post('/api/kdsp/account/account-verify-detail-update', {
    prefix: config.kdspApi,
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return businessCode;
}

export async function apiSave(params) {
  const { businessCode } = await request.post('/api/merchants/aftersales/addresses/edit', {
    prefix: config.kdspApi,
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return businessCode;
}

export async function apiAdd(params) {
  const { businessCode } = await request.post('/api/merchants/aftersales/addresses/add', {
    prefix: config.kdspApi,
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return businessCode;
}
